ORCA/M Asm65816 2.1.0

0001 6972                       title 'QD RgnDefs           GS ROM 2.0'
0002 6972              ****************************************************************
0003 6972              *                                                              *
0004 6972              *                      RgnDefs                                 *
0005 6972              *                                                              *
0006 6972              ****************************************************************
0007 6972
0008 6972              ****************************************************************
0009 6972              *                                                              *
0010 6972              *                   Copyright (C) 1986-1987                    *
0011 6972              *                   All Rights Reserved                        *
0012 6972              *                   Apple Computer, Inc.                       *
0013 6972              *
0014 6972              * Modification history:
0015 6972              *
0016 6972              * Feb 7, 1989       Konstantin and Dave
0017 6972              *
0018 6972              *                   Speed up point in region call.
0019 6972              *
0020 6972              *
0021 6972              * Feb 13, 1989      Konstantin and Dave
0022 6972              *
0023 6972              *                   Fixed bug in PtInRgn
0024 6972              *
0025 6972              * March 7, 1989     Konstantin
0026 6972              *
0027 6972              *                   Made XorScan call shorter and faster.
0028 6972              *
0029 6972              ****************************************************************
0030 6972                       string asis 
0031 6972                       blanks off 
0032 6972
0033 6972
0034 6972                       include 'all.macros' 
0035 6972
0036 6972                       include ':QDEquates:qd.data.asm' 
0037 6972
0038 6972                       INCLUDE ':QDEquates:core.globals1' 
0039 6972                       INCLUDE ':QDEquates:core.globals2' 
0040 6972                       INCLUDE ':QDEquates:region.equs' 
0041 6972                       INCLUDE ':QDEquates:rect.equs' 
0042 6972                       INCLUDE ':QDEquates:rgndefs.equs' 
0043 6972
0044 6972
0045 6972              ;-----------------------------------------------
0046 6972              ;
0047 6972              ;   Imported addresses
0048 6972              ;
0049 6972              ;-----------------------------------------------
0050 6972
0051 6972                       IMPORT BusyEC0 
0052 6972                       IMPORT BusyEC12 
0053 6972                       IMPORT BusyEC4 
0054 6972                       IMPORT BusyEC8 
0055 6972                       IMPORT BusyErr0 
0056 6972                       IMPORT BusyErr12 
0057 6972                       IMPORT BusyErr4 
0058 6972                       IMPORT BusyErr8 
0059 6972                       IMPORT DerefA 
0060 6972                       IMPORT DerefB 
0061 6972                       IMPORT DerefHandle 
0062 6972                       IMPORT GetNewHandle 
0063 6972                       IMPORT QDStart 
0064 6972                       IMPORT ReSizeHandle 
0065 6972                       IMPORT UnlockA 
0066 6972                       IMPORT UnlockHandle 
0067 6972
0068 6972              ;-----------------------------------------------
0069 6972              ;
0070 6972              ;   Forward addresses and entries
0071 6972              ;
0072 6972              ;-----------------------------------------------
0073 6972
0074 6972                       ENTRY DiffScan 
0075 6972                       ENTRY DoRgnOp 
0076 6972                       ENTRY InsetScan 
0077 6972                       ENTRY LocalMapPoint 
0078 6972                       ENTRY MapAndScale 
0079 6972                       ENTRY RetrieveRects 
0080 6972                       ENTRY RgnSector 
0081 6972                       ENTRY SectScan 
0082 6972                       ENTRY UnionScan 
0083 6972                       ENTRY XorScan 
0084 6972
0085 6972              ;                copy rgndefs/ptinrgn
0086 6972              ****************************************************************
0087 6972              *
0088 6972              * Function PtInRgn
0089 6972              *
0090 6972              ****************************************************************
0091 6972                       EXPORT PtInRgn 
0092 6972              PtInRgn  PROC 
0093 6972
0094 6972              OrigDirect equ   1
0095 6972              RTL1     equ   OrigDirect+2
0096 6972              RTL2     equ   RTL1+3
0097 6972              Rgn      equ   RTL2+3
0098 6972              PointPtr equ   Rgn+4
0099 6972              Result   equ   PointPtr+4
0100 6972
0101 6972 20 AA 0F              jsr   QDStart
0102 6975
0103 6975 A9 00 00              lda    #0                      	;zero out the result and the X-Reg
0104 6978 AA                    tax                            	;..(this is the internal result)
0105 6979 83 11                 sta    Result,s
0106 697B
0107 697B A3 0D                 lda    PointPtr,s              	;get the point to test into zero
0108 697D 85 2A                 sta    Temp                    	;..page (H,V)
0109 697F A3 0F                 lda    PointPtr+2,s
0110 6981 85 2C                 sta    Temp+2
0111 6983 A0 02 00              ldy    #2
0112 6986 A7 2A                 lda    [Temp]
0113 6988 85 D6                 sta    V
0114 698A B7 2A                 lda    [Temp],y
0115 698C 85 D8                 sta    H
0116 698E
0117 698E A3 0B                 lda    Rgn+2,s                 	;Temp = our region handle
0118 6990 85 2C                 sta    Temp+2
0119 6992 A3 09                 lda    Rgn,s
0120 6994 85 2A                 sta    Temp
0121 6996 B7 2A                 lda    [Temp],y                	;deref the handle using the fact
0122 6998 85 C2                 sta    BufPtr+2                	;..that Y-Reg is already two
0123 699A A7 2A                 lda    [Temp]
0124 699C 85 C0                 sta    BufPtr
0125 699E
0126 699E A5 D6                 lda    V                       	;Y-Reg is already two here
0127 69A0 D7 C0                 cmp    [BufPtr],y
0128 69A2 30 45                 bmi    allDone
0129 69A4 A0 06 00              ldy    #6
0130 69A7 D7 C0                 cmp    [BufPtr],y
0131 69A9 10 3E                 bpl    allDone
0132 69AB A5 D8                 lda    H
0133 69AD A0 04 00              ldy    #4
0134 69B0 D7 C0                 cmp    [BufPtr],y
0135 69B2 30 35                 bmi    allDone
0136 69B4 A0 08 00              ldy    #8
0137 69B7 D7 C0                 cmp    [BufPtr],y
0138 69B9 10 2E                 bpl    allDone
0139 69BB A9 0A 00              lda    #10
0140 69BE C7 C0                 cmp    [BufPtr]
0141 69C0 F0 22                 beq    isInTheRgn
0142 69C2              ;---------------------------------------------------------------
0143 69C2 C8           nextVert iny                            	;this looks in the region for the point
0144 69C3 C8                    iny   
0145 69C4 A5 D6                 lda    V
0146 69C6 D7 C0                 cmp    [BufPtr],y
0147 69C8 30 16                 bmi    done
0148 69CA
0149 69CA A5 D8                 lda    H
0150 69CC C8           nextHor  iny   
0151 69CD C8                    iny   
0152 69CE D7 C0                 cmp    [BufPtr],y
0153 69D0 30 03                 bmi    lookForEnd
0154 69D2 E8           doToggle inx   
0155 69D3 80 F7                 bra    nextHor
0156 69D5
0157 69D5 B7 C0        lookForEnd lda    [BufPtr],y
0158 69D7 C9 FF 3F              cmp    #MaxInt
0159 69DA F0 E6                 beq    nextVert
0160 69DC C8                    iny   
0161 69DD C8                    iny   
0162 69DE 80 F5                 bra    lookForEnd
0163 69E0              ;---------------------------------------------------------------
0164 69E0 8A           done     txa   
0165 69E1 4A                    lsr    a
0166 69E2 90 05                 bcc    allDone
0167 69E4
0168 69E4 A9 FF FF     isInTheRgn lda    #$FFFF
0169 69E7 83 11                 sta    Result,s
0170 69E9 4C 45 FC     allDone  jmp    BusyEC8
0171 69EC              ;---------------------------------------------------------------
0172 69EC
0173 69EC                       ENDP 
0174 69EC
0175 69EC              ****************************************************************
0176 69EC              *
0177 69EC              * Function RectInRgn
0178 69EC              *
0179 69EC              * Change History
0180 69EC              *
0181 69EC              * March 10, 1987  Steven Glass
0182 69EC              *
0183 69EC              * A case that was not working right showed a place where
0184 69EC              * register was being trashed.  This is working below.
0185 69EC              *
0186 69EC              * Change History
0187 69EC              * 7/23/87      GCP     replaced BufPtr with BufHandle. We were
0188 69EC              *                      looking in the wrong place before disposing
0189 69EC              *                      of the handle
0190 69EC              *
0191 69EC              ****************************************************************
0192 69EC                       EXPORT RectInRgn 
0193 69EC              RectInRgn PROC 
0194 69EC
0195 69EC              OrigDirect equ   1
0196 69EC              RTL1     equ   OrigDirect+2
0197 69EC              RTL2     equ   RTL1+3
0198 69EC              Rgn      equ   RTL2+3
0199 69EC              RectPtr  equ   Rgn+4
0200 69EC              Result   equ   RectPtr+4
0201 69EC
0202 69EC              RgnFlag  equ   PtCount+2
0203 69EC
0204 69EC 20 AA 0F              jsr   QDStart
0205 69EF
0206 69EF A9 00 00              lda   #0                       ; init result to false
0207 69F2 83 11                 sta   Result,s
0208 69F4 85 BC                 sta   BufHandle                ; init handle to nil
0209 69F6 85 BE                 sta   BufHandle+2
0210 69F8
0211 69F8 A3 09                 lda   Rgn,s                    ; pull Rgn handle off the stack
0212 69FA 85 50                 sta   RgnHandleA
0213 69FC A3 0B                 lda   Rgn+2,s
0214 69FE 85 52                 sta   RgnHandleA+2
0215 6A00
0216 6A00 A2 50 00              ldx   #RgnHandleA              ; set up dereference pointer
0217 6A03 20 0D 5B              jsr   DerefHandle              ; dereference and lock it
0218 6A06 85 54                 sta   RgnPtrA
0219 6A08 86 56                 stx   RgnPtrA+2
0220 6A0A
0221 6A0A A3 0D                 lda   RectPtr,s                ; get rectangle off stack
0222 6A0C 38                    sec   
0223 6A0D E9 02 00              sbc   #2                       ; fake out RgnSector (make it think
0224 6A10 85 64                 sta   RgnPtrB                  ; it really has a region by subtracting
0225 6A12 A3 0F                 lda   RectPtr+2,s              ; two from the pointer)
0226 6A14 E9 00 00              sbc   #0
0227 6A17 85 66                 sta   RgnPtrB+2
0228 6A19
0229 6A19 20 15 76              jsr   RgnSector
0230 6A1C
0231 6A1C A5 AE                 lda   RgnY1
0232 6A1E C5 B2                 cmp   RgnY2
0233 6A20 10 10                 bpl   GoHome
0234 6A22 A5 B0                 lda   RgnX1
0235 6A24 C5 B4                 cmp   RgnX2
0236 6A26 10 0A                 bpl   GoHome
0237 6A28 A7 54                 lda   [RgnPtrA]
0238 6A2A C9 0A 00              cmp   #10
0239 6A2D D0 06                 bne   NotYet
0240 6A2F 82 E7 00              brl   ItsInThere
0241 6A32 82 E9 00     GoHome   brl   NotInThere
0242 6A35 38           NotYet   sec   
0243 6A36 A5 B4                 lda   RgnX2
0244 6A38 E5 B0                 sbc   RgnX1
0245 6A3A 18                    clc   
0246 6A3B 69 0F 00              adc   #$000F                   ; past next full word
0247 6A3E 4A                    lsr   a                        ; divide by 8
0248 6A3F 4A                    lsr   a
0249 6A40 4A                    lsr   a
0250 6A41 29 FE FF              and   #$FFFE                   ; even number of words
0251 6A44 85 C4                 sta   PtCount                  ; tuck it away
0252 6A46 A2 BC 00              ldx   #BufHandle               ; offset to handle location
0253 6A49 20 62 5B              jsr   GetNewHandle             ; utility routine to get/deref handle
0254 6A4C 90 0B                 bcc   NoError
0255 6A4E 48                    pha                            ; save error
0256 6A4F A2 50 00              ldx   #RgnHandleA
0257 6A52 20 28 5B              jsr   UnlockHandle
0258 6A55 FA                    plx                            ; retrieve error
0259 6A56 4C 48 FC              jmp   BusyErr8
0260 6A59
0261 6A59 85 C0        NoError  sta   BufPtr
0262 6A5B 86 C2                 stx   BufPtr+2
0263 6A5D A4 C4                 ldy   PtCount                  ; get count
0264 6A5F 88 88                 DecYWd 
0265 6A61 A9 00 00              lda   #0
0266 6A64 97 C0        ClearLoop sta   [BufPtr],y
0267 6A66 88 88                 DecYWd 
0268 6A68 10 FA                 bpl   ClearLoop
0269 6A6A 64 C6                 stz   RgnFlag                  ; init our toggle to off
0270 6A6C A0 0A 00              ldy   #10
0271 6A6F A5 AE        NxtVert  lda   RgnY1
0272 6A71 D7 54                 cmp   [RgnPtrA],y              ; set flags on Y1-Rgn.Y
0273 6A73 30 5F                 bmi   FastTrack
0274 6A75 C8 C8                 IncYWd 
0275 6A77 B7 54        NxtHoriz lda   [RgnPtrA],y
0276 6A79 C8 C8                 IncYWd 
0277 6A7B C9 FF 3F              cmp   #MaxInt
0278 6A7E F0 EF                 beq   NxtVert
0279 6A80 C5 B4                 cmp   RgnX2                    ; is it too far?
0280 6A82 10 F3                 bpl   NxtHoriz                 ; yes, ignore it
0281 6A84
0282 6A84              * It was somewhere left of the right edge of our rect.  We must toggle
0283 6A84              * our inversion flag.
0284 6A84
0285 6A84 48                    pha                            ; save point (added 10 Mar 87-SEG)
0286 6A85
0287 6A85 A5 C6                 lda   RgnFlag
0288 6A87 49 FF FF              eor   #$FFFF
0289 6A8A 85 C6                 sta   RgnFlag
0290 6A8C
0291 6A8C 68                    pla                            ; get point back (added 10 mar 87)
0292 6A8D
0293 6A8D C5 B0                 cmp   RgnX1
0294 6A8F 30 E6                 bmi   NxtHoriz
0295 6A91
0296 6A91              * Now we have an inversion point that falls within X1 <= X < X2
0297 6A91
0298 6A91 5A                    phy                            ; save y
0299 6A92 38                    sec   
0300 6A93 E5 B0                 sbc   RgnX1                    ; normalize it
0301 6A95 85 2A                 sta   Temp
0302 6A97 29 0F 00              and   #$000F                   ; mod 16
0303 6A9A 0A                    asl   a                        ; make it a byte offset
0304 6A9B AA                    tax   
0305 6A9C BF B4 6A FE           lda   >Mask,x
0306 6AA0 85 2C                 sta   Temp+2
0307 6AA2 A5 2A                 lda   Temp
0308 6AA4 4A                    lsr   a                        ; find the byte the point is in
0309 6AA5 4A                    lsr   a
0310 6AA6 4A                    lsr   a
0311 6AA7 29 FE FF              and   #$FFFE                   ; align it to a word boundary
0312 6AAA A8                    tay                            ; index it
0313 6AAB B7 C0                 lda   [BufPtr],y               ; get what it is now
0314 6AAD 45 2C                 eor   Temp+2                   ; toggle the bit
0315 6AAF 97 C0                 sta   [BufPtr],y               ; put it back
0316 6AB1 7A                    ply   
0317 6AB2 80 C3                 bra   NxtHoriz
0318 6AB4
0319 6AB4 00 80 00 40  Mask     DC W:$8000,$4000,$2000,$1000
0320 6ABC 00 08 00 04           DC W:$0800,$0400,$0200,$0100
0321 6AC4 80 00 40 00           DC W:$0080,$0040,$0020,$0010
0322 6ACC 08 00 04 00           DC W:$0008,$0004,$0002,$0001
0323 6AD4
0324 6AD4              * When we get to the FastTrack, we are guaranteed to be past the first
0325 6AD4              * scan line of the rectangle, so any inversion point which falls within
0326 6AD4              * the horizontal limits X1 <= X < X2 means we've found a hit.  First,
0327 6AD4              * check for hits up to this point.  If there aren't any, keep scanning
0328 6AD4              * until we pass Y2 or find one.
0329 6AD4
0330 6AD4 A5 C6        FastTrack lda   RgnFlag
0331 6AD6 D0 41                 bne   ItsInThere
0332 6AD8 84 2A                 sty   Temp
0333 6ADA A4 C4                 ldy   PtCount
0334 6ADC 88 88                 DecYWd 
0335 6ADE B7 C0        TestLoop lda   [BufPtr],y
0336 6AE0 D0 37                 bne   ItsInThere
0337 6AE2 88 88                 DecYWd 
0338 6AE4 10 F8                 bpl   TestLoop
0339 6AE6 A4 2A                 ldy   Temp
0340 6AE8 B7 54        NxtVert2 lda   [RgnPtrA],y
0341 6AEA C8 C8                 IncYWd 
0342 6AEC C5 B2                 cmp   RgnY2                    ; set flags on Rgn.Y-RgnY2
0343 6AEE 10 2E                 bpl   NotInThere
0344 6AF0 B7 54        NxtHoriz2 lda   [RgnPtrA],y
0345 6AF2 C8 C8                 IncYWd 
0346 6AF4 C9 FF 3F              cmp   #MaxInt
0347 6AF7 F0 EF                 beq   NxtVert2
0348 6AF9 C5 B0                 cmp   RgnX1
0349 6AFB 10 09                 bpl   NoToggle
0350 6AFD A5 C6                 lda   RgnFlag
0351 6AFF 49 FF FF              eor   #$FFFF
0352 6B02 85 C6                 sta   RgnFlag
0353 6B04 80 EA                 bra   NxtHoriz2
0354 6B06
0355 6B06 C5 B4        NoToggle cmp   RgnX2
0356 6B08 30 0F                 bmi   ItsInThere
0357 6B0A A5 C6                 lda   RgnFlag                  ; if the rgn flag is on, we've got one
0358 6B0C D0 0B                 bne   ItsInThere
0359 6B0E
0360 6B0E              * It wasn't in there, so advance us to the end of scan marker
0361 6B0E
0362 6B0E B7 54        SkipThisOne lda   [RgnPtrA],y
0363 6B10 C8 C8                 IncYWd 
0364 6B12 C9 FF 3F              cmp   #MaxInt
0365 6B15 D0 F7                 bne   SkipThisOne
0366 6B17 80 CF                 bra   NxtVert2
0367 6B19
0368 6B19 A9 01 00     ItsInThere lda   #1
0369 6B1C 83 11                 sta   Result,s
0370 6B1E A2 50 00     NotInThere ldx   #RgnHandleA
0371 6B21 20 28 5B              jsr   UnlockHandle
0372 6B24
0373 6B24 A5 BC                 lda   BufHandle
0374 6B26 05 BE                 ora   BufHandle+2
0375 6B28
0376 6B28 F0 15                 beq   NoHandle
0377 6B2A A2 BC 00              ldx   #BufHandle
0378 6B2D 20 28 5B              jsr   UnlockHandle
0379 6B30 A5 BE 48 A5           PushLong BufHandle 
0380 6B36 A2 02 10 22           _DisposeHandle 
0381 6B3D B0 03                 bcs   Err
0382 6B3F 4C 45 FC     NoHandle jmp   BusyEC8
0383 6B42 4C 48 FC     Err      jmp   BusyErr8
0384 6B45
0385 6B45                       ENDP 
0386 6B45              ;                copy rgndefs/rgnsave
0387 6B45              ****************************************************************
0388 6B45              *
0389 6B45              * RgnSave
0390 6B45              *
0391 6B45              * Internal routine to determine if we are save in the process
0392 6B45              * of defining a region.
0393 6B45              *
0394 6B45              * 3/9/89            Mensch
0395 6B45              * Modify the dirty flags at the proper times
0396 6B45              ****************************************************************
0397 6B45                       EXPORT RgnSave 
0398 6B45              RgnSave  PROC 
0399 6B45              *              using coredata
0400 6B45
0401 6B45
0402 6B45 A0 94 00              ldy   #o_RgnSave
0403 6B48 B7 24                 lda   [PortRef],y
0404 6B4A 85 BC                 sta   BufHandle
0405 6B4C C8                    iny   
0406 6B4D C8                    iny   
0407 6B4E B7 24                 lda   [PortRef],y
0408 6B50 85 BE                 sta   BufHandle+2
0409 6B52 05 BC                 ora   BufHandle
0410 6B54 F0 02                 beq   IsZero
0411 6B56
0412 6B56 38           NotZero  sec   
0413 6B57 60                    rts   
0414 6B58
0415 6B58 DA           IsZero   phx   
0416 6B59 A2 00 02              ldx   #512
0417 6B5C B5 EC                 lda   <DirtyDPFlags,x
0418 6B5E 09 0C 00              ora   #NoRgnRecord+NoPolyRecord
0419 6B61 95 EC                 sta   <DirtyDPFlags,x
0420 6B63 FA                    plx   
0421 6B64 A9 00 00              lda   #0
0422 6B67 18                    clc   
0423 6B68 60                    rts   
0424 6B69
0425 6B69                       ENDP 
0426 6B69
0427 6B69              ;                copy rgndefs/putrect
0428 6B69              ****************************************************************
0429 6B69              *
0430 6B69              * Procedure AddPt2Rgn;
0431 6B69              *
0432 6B69              *   A point is passed in registers, the x value in the x register
0433 6B69              *   and the y value in the A register.  These are added to the
0434 6B69              *   inversion point list and y is incremented.  No other registers
0435 6B69              *   are changed.
0436 6B69              *
0437 6B69              ****************************************************************
0438 6B69                       EXPORT AddPt2Rgn 
0439 6B69              AddPt2Rgn PROC 
0440 6B69
0441 6B69 97 C0                 sta   [BufPtr],y               ; store y value
0442 6B6B C8                    iny                            ; increment y
0443 6B6C C8                    iny                            ; increment y
0444 6B6D 8A                    txa                            ; get x value
0445 6B6E 97 C0                 sta   [BufPtr],y               ; store x value
0446 6B70 C8                    iny                            ; increment y
0447 6B71 C8                    iny                            ; increment y
0448 6B72 60                    rts                            ; get outa here
0449 6B73
0450 6B73                       ENDP 
0451 6B73
0452 6B73              ****************************************************************
0453 6B73              *
0454 6B73              * Procedure PutRect(r:rect; bufHandle:Handle; var Index,Size:integer);
0455 6B73              *
0456 6B73              *   Puts the four inversion points of a rectangle.
0457 6B73              *
0458 6B73              *   This being an internal routine, the rectangle is stored on zero
0459 6B73              *   page in Y1,X1,Y2,X2.  bufHandle is a handle to a list of inversion
0460 6B73              *   points and has been placed in RgnHandleC.  The first two bytes of
0461 6B73              *   the list are the maximum size.  The second two bytes are the
0462 6B73              *   current size.  We will bump the handle by 1024 bytes if we
0463 6B73              *   don't have enough room for 16 more bytes (4 points), then add the
0464 6B73              *   four points onto the end.  Note that the number of points is
0465 6B73              *   (index div 4) - 1
0466 6B73              *
0467 6B73              ****************************************************************
0468 6B73                       EXPORT iPutRect 
0469 6B73              iPutRect PROC 
0470 6B73
0471 6B73              *              using ErrorData
0472 6B73
0473 6B73              OrigDirect equ   1
0474 6B73              RTL1     equ   OrigDirect+2
0475 6B73              RTL2     equ   RTL1+3
0476 6B73
0477 6B73              * avoid locking/derefing once the caller does it properly
0478 6B73
0479 6B73 A2 BC 00              ldx   #BufHandle
0480 6B76 20 0D 5B              jsr   DerefHandle              ; dereference the current handle
0481 6B79 85 C0                 sta   BufPtr                   ; save pointer returned in A & X
0482 6B7B 86 C2                 stx   BufPtr+2
0483 6B7D A0 02 00              ldy   #2                       ; current index offset
0484 6B80 B7 C0                 lda   [BufPtr],y               ; get index
0485 6B82 48                    pha                            ; save it
0486 6B83 18                    clc                            ; prepare for add
0487 6B84 69 10 00              adc   #16                      ; room we need for 4 points
0488 6B87 97 C0                 sta   [BufPtr],y               ; store it while we have it
0489 6B89 C7 C0                 cmp   [BufPtr]                 ; set flags on index - size
0490 6B8B 90 16                 bcc   SizeOk                   ; blt SizeOk
0491 6B8D F0 14                 beq   SizeOk                   ; ble SizeOk
0492 6B8F A7 C0                 lda   [BufPtr]                 ; get current maximum
0493 6B91 18                    clc                            ; clear carry for adc
0494 6B92
0495 6B92              * We generally won't be calling too many rectangles in a row, so bump
0496 6B92              * the size just by a page.
0497 6B92
0498 6B92 69 00 01              adc   #256                     ; bump size by 256
0499 6B95 B0 31                 bcs   BufferOverflow           ; if we wrapped, we quit
0500 6B97 A2 BC 00              ldx   #BufHandle               ; point X at BufHandle
0501 6B9A 20 3B 5B              jsr   ReSizeHandle             ; resize, relock, rederef
0502 6B9D B0 2C                 bcs   ErrorOut                 ; if we failed, propogate the error
0503 6B9F 85 C0                 sta   BufPtr                   ; save pointer
0504 6BA1 86 C2                 stx   BufPtr+2
0505 6BA3 7A           SizeOk   ply                            ; reload y
0506 6BA4 A6 A8                 ldx   x1                       ; get left
0507 6BA6 A5 A6                 lda   y1                       ; get top
0508 6BA8 20 69 6B              jsr   AddPt2Rgn                ; put point
0509 6BAB A6 AC                 ldx   x2                       ; get right
0510 6BAD A5 A6                 lda   y1                       ; get top
0511 6BAF 20 69 6B              jsr   AddPt2Rgn                ; put point
0512 6BB2 A6 A8                 ldx   x1                       ; get left
0513 6BB4 A5 AA                 lda   y2                       ; get bottom
0514 6BB6 20 69 6B              jsr   AddPt2Rgn                ; put point
0515 6BB9 A6 AC                 ldx   x2                       ; get right
0516 6BBB A5 AA                 lda   y2                       ; get bottom
0517 6BBD 20 69 6B              jsr   AddPt2Rgn                ; put point
0518 6BC0
0519 6BC0              * avoid unlocking once the caller does it
0520 6BC0
0521 6BC0 A2 BC 00              ldx   #BufHandle               ; unlock the buffer handle
0522 6BC3 20 28 5B              jsr   UnlockHandle
0523 6BC6 18                    clc   
0524 6BC7 6B                    rtl   
0525 6BC8
0526 6BC8 A9 33 04     BufferOverflow lda   #RgnFull           ; error to say we had troubles
0527 6BCB 48           ErrorOut pha                            ; save error code
0528 6BCC A2 BC 00              ldx   #BufHandle               ; unlock the buffer handle
0529 6BCF 20 28 5B              jsr   UnlockHandle
0530 6BD2 68                    pla                            ; restore error code
0531 6BD3 38                    sec                            ; restore error flag
0532 6BD4 6B                    rtl                            ; get outa here
0533 6BD5
0534 6BD5                       ENDP 
0535 6BD5              ;                copy rgndefs/putline
0536 6BD5              ****************************************************************
0537 6BD5              *
0538 6BD5              * Procedure PutLine(pt1,pt2:Point; dst:Handle; var index,bufmax:integer);
0539 6BD5              *
0540 6BD5              *   Puts inversion points for a line segment.
0541 6BD5              *
0542 6BD5              *   This being an internal routine, the points are stored on zero
0543 6BD5              *   page in Y1,X1,Y2,X2.  bufHandle is a handle to a list of inversion
0544 6BD5              *   points.  The first two bytes of the list are the maximum size.
0545 6BD5              *   The second two bytes are the current size.
0546 6BD5              *
0547 6BD5              ****************************************************************
0548 6BD5                       EXPORT iPutLine 
0549 6BD5              iPutLine PROC 
0550 6BD5
0551 6BD5              *              using ErrorData
0552 6BD5
0553 6BD5              OrigDirect equ   1
0554 6BD5              RTL1     equ   OrigDirect+2
0555 6BD5              RTL2     equ   RTL1+3
0556 6BD5
0557 6BD5              * We assume in Putline that BufHandle is already dereferenced and locked
0558 6BD5              * down for us.  This should make life easier for the polygon routines, so
0559 6BD5              * that the dereferencing and locking need only be done once or in the
0560 6BD5              * event of a resizing.
0561 6BD5
0562 6BD5              * avoid locking/derefing once the caller does it
0563 6BD5
0564 6BD5 A2 BC 00              ldx   #BufHandle               ; get the inversion point buffer
0565 6BD8 20 0D 5B              jsr   DerefHandle              ; dereference it
0566 6BDB 85 C0                 sta   BufPtr                   ; save pointer returned in A & X
0567 6BDD 86 C2                 stx   BufPtr+2
0568 6BDF
0569 6BDF A0 02 00              ldy   #2                       ; current index offset
0570 6BE2 B7 C0                 lda   [BufPtr],y               ; get index
0571 6BE4 85 C6                 sta   Index                    ; keep track of it
0572 6BE6
0573 6BE6              * If line is vertical, ignore it since it must already connect to
0574 6BE6              * existing horizontal lines.
0575 6BE6
0576 6BE6 38                    sec                            ; set for subtract
0577 6BE7 A5 AC                 lda   X2                       ; we'll subtract so we have the
0578 6BE9 E5 A8                 sbc   X1                       ; result in case we need it
0579 6BEB D0 03                 bne   NotVertical
0580 6BED 4C 2F 6D              jmp   Exit                     ; jump out all the way
0581 6BF0
0582 6BF0 85 CA        NotVertical sta   DeltaX                ; save this for later
0583 6BF2
0584 6BF2              * Calculate bytes needed as 8 * (Min(abs(dh),abs(dv))+1)
0585 6BF2
0586 6BF2 10 04                 bpl   DhPos
0587 6BF4 49 FF FF              eor   #$FFFF
0588 6BF7 1A                    inc   a
0589 6BF8 85 2A        DhPos    sta   Temp                     ; switch to using RgnY1..RgnX2
0590 6BFA A5 A6                 lda   Y1
0591 6BFC 85 AE                 sta   RgnY1
0592 6BFE A5 A8                 lda   X1
0593 6C00 85 B0                 sta   RgnX1
0594 6C02 A5 AA                 lda   Y2
0595 6C04 85 B2                 sta   RgnY2
0596 6C06 A5 AC                 lda   X2
0597 6C08 85 B4                 sta   RgnX2
0598 6C0A
0599 6C0A 38                    sec   
0600 6C0B A5 B2                 lda   RgnY2
0601 6C0D E5 AE                 sbc   RgnY1
0602 6C0F 85 CC                 sta   DeltaY
0603 6C11 10 04                 bpl   DvPos
0604 6C13 49 FF FF              eor   #$FFFF
0605 6C16 1A                    inc   a
0606 6C17 C5 2A        DvPos    cmp   Temp
0607 6C19 30 02                 bmi   DvLess
0608 6C1B A5 2A                 lda   Temp
0609 6C1D 1A           DvLess   inc   a                        ; bump by 1
0610 6C1E              *
0611 6C1E              * Addition by SEG (20 May 86) to return error
0612 6C1E              * on overflow
0613 6C1E              *
0614 6C1E C9 00 20              cmp   #$2000                   ; check this number to see if it is too
0615 6C21 B0 18                 bcs   BufferOverflow           ; big to handle and quit if yes
0616 6C23              *
0617 6C23              * End addition.
0618 6C23              *
0619 6C23 0A                    asl   a                        ; now mult by 8
0620 6C24 0A                    asl   a
0621 6C25 0A                    asl   a
0622 6C26 18                    clc   
0623 6C27 65 C6                 adc   Index
0624 6C29 B0 10                 bcs   BufferOverflow           ; if we wrapped, we quit
0625 6C2B C7 C0                 cmp   [BufPtr]
0626 6C2D 90 1D                 bcc   NoGrow
0627 6C2F F0 1B                 beq   NoGrow
0628 6C31 A2 BC 00              ldx   #BufHandle               ; get offset to handle
0629 6C34 20 3B 5B              jsr   ResizeHandle             ; resize it
0630 6C37 90 0F                 bcc   SavePtr
0631 6C39 80 03                 bra   ErrorOut
0632 6C3B
0633 6C3B A9 33 04     BufferOverflow lda   #RgnFull           ; error to say we had troubles
0634 6C3E 48           ErrorOut pha                            ; save error code
0635 6C3F A2 BC 00              ldx   #BufHandle               ; unlock the buffer handle
0636 6C42 20 28 5B              jsr   UnlockHandle
0637 6C45 68                    pla                            ; restore error code
0638 6C46 38                    sec                            ; restore error flag
0639 6C47 6B                    rtl                            ; get outa here
0640 6C48
0641 6C48 85 C0        SavePtr  sta   BufPtr                   ; save pointer
0642 6C4A 86 C2                 stx   BufPtr+2
0643 6C4C A5 AE        NoGrow   lda   RgnY1
0644 6C4E C5 B2                 cmp   RgnY2
0645 6C50 D0 13                 bne   Slanted
0646 6C52 A5 AE                 lda   RgnY1
0647 6C54 A6 B0                 ldx   RgnX1
0648 6C56 A4 C6                 ldy   Index                    ; AddPt2Rgn updates y
0649 6C58 20 69 6B              jsr   AddPt2Rgn
0650 6C5B A5 B2                 lda   RgnY2
0651 6C5D A6 B4                 ldx   RgnX2
0652 6C5F 20 69 6B              jsr   AddPt2Rgn
0653 6C62 4C 24 6D              jmp   Done                     ; go fix up the length
0654 6C65
0655 6C65 30 0E        Slanted  bmi   NoSwap                   ; if Y1-Y2 < 0, don't swap
0656 6C67 A6 B2                 ldx   RgnY2                    ; A already has Y1
0657 6C69 85 B2                 sta   RgnY2
0658 6C6B 86 AE                 stx   RgnY1
0659 6C6D A5 B0                 lda   RgnX1                    ; swap horizontals to match
0660 6C6F A6 B4                 ldx   RgnX2
0661 6C71 85 B4                 sta   RgnX2                    ; we don't need to swap deltas
0662 6C73 86 B0                 stx   RgnX1                    ; because the sign changes cancel
0663 6C75 A5 AE        NoSwap   lda   RgnY1
0664 6C77 85 D6                 sta   V                        ; init V to top V
0665 6C79 F4 00 00              pea   0                        ; room for result
0666 6C7C F4 00 00              pea   0
0667 6C7F D4 CA                 pei   DeltaX                   ; sure glad we caught these earlier
0668 6C81 D4 CC                 pei   DeltaY
0669 6C83 A2 0B 0E 22           _FixRatio                      ; get the ratio
0670 6C8A 68                    pla   
0671 6C8B 85 CE                 sta   Slope                    ; hmmm - zero page already ?
0672 6C8D 68                    pla   
0673 6C8E 85 D0                 sta   Slope+2
0674 6C90
0675 6C90 A5 B0                 lda   RgnX1
0676 6C92 85 D4                 sta   Horiz+2                  ; Horiz.Int := top horiz
0677 6C94 A9 00 80              lda   #$8000
0678 6C97 85 D2                 sta   Horiz                    ; Horiz.Fract := 1/2
0679 6C99
0680 6C99              * Adjust horiz depending on sign and magnitude of slope
0681 6C99              * Horiz := Horiz + Slope/2
0682 6C99
0683 6C99 A5 D0                 lda   Slope+2                  ; is slope negative
0684 6C9B 0A                    asl   a                        ; get sign of slope
0685 6C9C A5 D0                 lda   Slope+2                  ; get high word of slope back
0686 6C9E 6A                    ror   a                        ; divide by 2, preserving sign
0687 6C9F 85 2A                 sta   Temp                     ; save the high word
0688 6CA1 A5 CE                 lda   Slope
0689 6CA3 6A                    ror   a                        ; A has low word of slope/2
0690 6CA4 18                    clc   
0691 6CA5 65 D2                 adc   Horiz                    ; add into Horiz
0692 6CA7 85 D2                 sta   Horiz                    ; and save it
0693 6CA9 A5 2A                 lda   Temp                     ; get the high word back
0694 6CAB 65 D4                 adc   Horiz+2                  ; add using carry
0695 6CAD 85 D4                 sta   Horiz+2                  ; and save it
0696 6CAF
0697 6CAF A5 D0                 lda   Slope+2                  ; is slope negative?
0698 6CB1 30 11                 bmi   NegSlope                 ; yes, continue
0699 6CB3 D0 16                 bne   SlopeOk                  ; if high word >0, then slope >= 1
0700 6CB5
0701 6CB5              * Add slope to LeftEdge
0702 6CB5
0703 6CB5 18                    clc   
0704 6CB6 A5 CE                 lda   Slope                    ; get low word
0705 6CB8 65 D2                 adc   Horiz                    ; add low word of Horiz
0706 6CBA 85 D2                 sta   Horiz                    ; save it
0707 6CBC A5 D0                 lda   Slope+2                  ; get high word of slope
0708 6CBE 65 D4                 adc   Horiz+2                  ; add high word of Horiz with carry
0709 6CC0 85 D4                 sta   Horiz+2                  ; save high word
0710 6CC2 80 07                 bra   SlopeOk                  ; and continue
0711 6CC4
0712 6CC4 49 FF FF     NegSlope eor   #$FFFF                   ; is slope >= FFFF0000
0713 6CC7 F0 02                 beq   SlopeOk
0714 6CC9 E6 D4                 inc   Horiz+2                  ; add 1 to horiz
0715 6CCB              SlopeOk                                 ; 
0716 6CCB
0717 6CCB              * For Vert := TopV to BotV-1 add slope to Horiz and put slabs
0718 6CCB
0719 6CCB A5 B0                 lda   RgnX1
0720 6CCD 85 D8                 sta   H
0721 6CCF A4 C6                 ldy   Index
0722 6CD1 A5 D8        Loop     lda   H
0723 6CD3 C5 D4                 cmp   Horiz+2
0724 6CD5 F0 1A                 beq   NoChng
0725 6CD7 A5 D6                 lda   V                        ; get current V
0726 6CD9 97 C0                 sta   [BufPtr],y               ; put it
0727 6CDB C8 C8                 IncYWd 
0728 6CDD A5 D8                 lda   H                        ; get old H
0729 6CDF 97 C0                 sta   [BufPtr],y               ; put it
0730 6CE1 C8 C8                 IncYWd 
0731 6CE3 A5 D6                 lda   V                        ; get V again
0732 6CE5 97 C0                 sta   [BufPtr],y               ; put it
0733 6CE7 C8 C8                 IncYWd 
0734 6CE9 A5 D4                 lda   Horiz+2                  ; get new H
0735 6CEB 97 C0                 sta   [BufPtr],y               ; put it
0736 6CED 85 D8                 sta   H                        ; update H
0737 6CEF C8 C8                 IncYWd 
0738 6CF1 E6 D6        NoChng   inc   V                        ; bump V
0739 6CF3 18                    clc   
0740 6CF4 A5 CE                 lda   Slope
0741 6CF6 65 D2                 adc   Horiz
0742 6CF8 85 D2                 sta   Horiz
0743 6CFA A5 D0                 lda   Slope+2
0744 6CFC 65 D4                 adc   Horiz+2
0745 6CFE 85 D4                 sta   Horiz+2
0746 6D00 A5 D6                 lda   V
0747 6D02 C5 B2                 cmp   RgnY2
0748 6D04 D0 CB                 bne   Loop
0749 6D06
0750 6D06              * Finish up last slab
0751 6D06
0752 6D06 A5 D8                 lda   H
0753 6D08 C5 B4                 cmp   RgnX2
0754 6D0A F0 18                 beq   Done
0755 6D0C A5 D6                 lda   V
0756 6D0E 97 C0                 sta   [BufPtr],y
0757 6D10 C8 C8                 IncYWd 
0758 6D12 A5 D8                 lda   H
0759 6D14 97 C0                 sta   [BufPtr],y
0760 6D16 C8 C8                 IncYWd 
0761 6D18 A5 D6                 lda   V
0762 6D1A 97 C0                 sta   [BufPtr],y
0763 6D1C C8 C8                 IncYWd 
0764 6D1E A5 B4                 lda   RgnX2
0765 6D20 97 C0                 sta   [BufPtr],y
0766 6D22 C8 C8                 IncYWd 
0767 6D24 98           Done     tya   
0768 6D25 A0 02 00              ldy   #2
0769 6D28 97 C0                 sta   [BufPtr],y
0770 6D2A 4A                    lsr   a                        ; divide by 4
0771 6D2B 4A                    lsr   a
0772 6D2C 3A                    dec   a
0773 6D2D 85 C4                 sta   PtCount                  ; be a good neighbor
0774 6D2F
0775 6D2F              * avoid unlocking once the caller does it
0776 6D2F
0777 6D2F A2 BC 00     Exit     ldx   #BufHandle               ; set up offset
0778 6D32 20 28 5B              jsr   UnlockHandle             ; get rid of this when okay
0779 6D35 18                    clc   
0780 6D36 6B                    rtl   
0781 6D37
0782 6D37                       ENDP 
0783 6D37              ;                copy rgndefs/putrgn
0784 6D37              *****************************************************************
0785 6D37              *
0786 6D37              * Procedure PutRgn
0787 6D37              *
0788 6D37              *   Input is a RgnHandle in RgnHandleA and buffer in BufHandle.
0789 6D37              *   The buffer size is held in the first two bytes of BufHandle's
0790 6D37              *   data, and the index (offset to the end of the buffer) in
0791 6D37              *   bytes 2-3 of the same.  PutRgn expands a region out to an
0792 6D37              *   array of inversion points, and thus functions as the inverse
0793 6D37              *   of PackRgn.  The caller should unlock RgnHandleA after use.
0794 6D37              *
0795 6D37              ****************************************************************
0796 6D37                       EXPORT iPutRgn 
0797 6D37              iPutRgn  PROC 
0798 6D37
0799 6D37              *              using ErrorData
0800 6D37
0801 6D37              * delete the next eight lines once BufHandle is set up correctly
0802 6D37
0803 6D37 A2 BC 00              ldx   #BufHandle               ; dereference and lock BufHandle
0804 6D3A 20 0D 5B              jsr   DerefHandle
0805 6D3D 85 C0                 sta   BufPtr                   ; save pointer
0806 6D3F 86 C2                 stx   BufPtr+2
0807 6D41
0808 6D41 A2 50 00              ldx   #RgnHandleA              ; dereference and lock RgnHandleA
0809 6D44 20 0D 5B              jsr   DerefHandle
0810 6D47 85 54                 sta   RgnPtrA                  ; save pointer returned in A & X
0811 6D49 86 56                 stx   RgnPtrA+2
0812 6D4B
0813 6D4B A0 02 00              ldy   #2                       ; offset to current index
0814 6D4E B7 C0                 lda   [BufPtr],y               ; get buffer length
0815 6D50 85 C6                 sta   Index                    ; save index
0816 6D52 A7 54                 lda   [RgnPtrA]                ; get region size
0817 6D54 0A                    asl   a                        ; times 2
0818 6D55 18                    clc                            ; prepare for add
0819 6D56 65 C6                 adc   Index                    ; what we'll need
0820 6D58 C7 54                 cmp   [RgnPtrA]                ; set flags on needed-current
0821 6D5A 90 22                 bcc   NoGrow                   ; if current > needed, ok
0822 6D5C F0 20                 beq   NoGrow                   ; or even this way
0823 6D5E 69 00 01              adc   #256                     ; bump our size for some sluff
0824 6D61 B0 0A                 bcs   BufferOverflow           ; if we wrapped, we report an error
0825 6D63 A2 BC 00              ldx   #BufHandle               ; offset to the handle to resize
0826 6D66 20 3B 5B              jsr   ResizeHandle             ; resize BufHandle
0827 6D69 90 0F                 bcc   SavePtr
0828 6D6B 80 03                 bra   ErrorOut
0829 6D6D
0830 6D6D A9 33 04     BufferOverflow lda   #RgnFull           ; error to say we had troubles
0831 6D70 48           ErrorOut pha                            ; save error code
0832 6D71 A2 BC 00              ldx   #BufHandle               ; unlock the buffer handle
0833 6D74 20 28 5B              jsr   UnlockHandle
0834 6D77 68                    pla                            ; restore error code
0835 6D78 38                    sec                            ; restore error flag
0836 6D79 6B                    rtl                            ; get outa here
0837 6D7A
0838 6D7A 85 C0        SavePtr  sta   BufPtr                   ; save pointer
0839 6D7C 86 C2                 stx   BufPtr+2
0840 6D7E A9 0A 00     NoGrow   lda   #10                      ; size of a rectangular region
0841 6D81 C7 54                 cmp   [RgnPtrA]                ; is region rectangular
0842 6D83 D0 5C                 bne   NotRect                  ; no, continue
0843 6D85
0844 6D85              * Use the bounding box to insert 4 points (Top,Left), (Top,Right),
0845 6D85              * (Bottom,Left), and (Bottom,Right).
0846 6D85
0847 6D85 A0 08 00              ldy   #8                       ; offset to right
0848 6D88 B7 54                 lda   [RgnPtrA],y              ; get right
0849 6D8A 48                    pha                            ; push it
0850 6D8B A0 06 00              ldy   #6                       ; offset to bottom
0851 6D8E B7 54                 lda   [RgnPtrA],y              ; get bottom
0852 6D90 48                    pha                            ; push it
0853 6D91 A0 04 00              ldy   #4                       ; offset to left
0854 6D94 B7 54                 lda   [RgnPtrA],y              ; get left
0855 6D96 48                    pha                            ; push it
0856 6D97 A0 02 00              ldy   #2                       ; offset to top
0857 6D9A B7 54                 lda   [RgnPtrA],y              ; get top
0858 6D9C A4 C6                 ldy   Index                    ; destination for next point
0859 6D9E AA                    tax                            ; save top in x
0860 6D9F
0861 6D9F 97 C0                 sta   [BufPtr],y               ; save top
0862 6DA1 C8 C8                 IncYWd 
0863 6DA3
0864 6DA3 A3 01                 lda   1,s                      ; get left
0865 6DA5 97 C0                 sta   [BufPtr],y               ; save it
0866 6DA7 C8 C8                 IncYWd 
0867 6DA9
0868 6DA9 8A                    txa                            ; get top
0869 6DAA 97 C0                 sta   [BufPtr],y               ; save top again
0870 6DAC C8 C8                 IncYWd 
0871 6DAE
0872 6DAE A3 05                 lda   5,s                      ; get right
0873 6DB0 97 C0                 sta   [BufPtr],y               ; save right
0874 6DB2 C8 C8                 IncYWd 
0875 6DB4
0876 6DB4 A3 03                 lda   3,s                      ; get bottom
0877 6DB6 AA                    tax                            ; save it in x
0878 6DB7 97 C0                 sta   [BufPtr],y               ; save bottom
0879 6DB9 C8 C8                 IncYWd 
0880 6DBB
0881 6DBB 68                    pla                            ; get left
0882 6DBC 97 C0                 sta   [BufPtr],y               ; save it
0883 6DBE C8 C8                 IncYWd                         ; bump y
0884 6DC0
0885 6DC0 68                    pla                            ; get bottom
0886 6DC1 97 C0                 sta   [BufPtr],y               ; save it
0887 6DC3 C8 C8                 IncYWd                         ; bump y
0888 6DC5
0889 6DC5 68                    pla                            ; get right
0890 6DC6 97 C0                 sta   [BufPtr],y               ; save it
0891 6DC8 C8 C8                 IncYWd                         ; bump y
0892 6DCA
0893 6DCA 98                    tya                            ; transfer index
0894 6DCB A0 02 00     Done     ldy   #2                       ; offset to index
0895 6DCE 97 C0                 sta   [BufPtr],y               ; save index
0896 6DD0 4A                    lsr   a
0897 6DD1 4A                    lsr   a
0898 6DD2 3A                    dec   a
0899 6DD3 85 C4                 sta   PtCount                  ; be a good neighbor
0900 6DD5 A2 BC 00              ldx   #BufHandle
0901 6DD8 20 28 5B              jsr   UnlockHandle
0902 6DDB 18                    clc                            ; no error
0903 6DDC 6B                    rtl   
0904 6DDD
0905 6DDD A5 C6        Cleanup  lda   Index                    ; get current offset
0906 6DDF 80 EA                 bra   Done                     ; share code
0907 6DE1
0908 6DE1 A0 0A 00     NotRect  ldy   #10                      ; offset to first vert
0909 6DE4 B7 54        NxtVert  lda   [RgnPtrA],y              ; get next vert
0910 6DE6 C9 FF 3F              cmp   #MaxInt                  ; is it MaxInt
0911 6DE9 F0 F2                 beq   Cleanup                  ; if so, clean up and quit
0912 6DEB 85 2A                 sta   Temp                     ; stow it
0913 6DED C8 C8                 IncYWd                         ; bump y
0914 6DEF B7 54        NextHor  lda   [RgnPtrA],y              ; get next horizontal
0915 6DF1 C8 C8                 IncYWd                         ; bump y
0916 6DF3 C9 FF 3F              cmp   #MaxInt                  ; is it Maxint?
0917 6DF6 F0 EC                 beq   NxtVert                  ; if so, check vertical
0918 6DF8 AA                    tax                            ; stow it
0919 6DF9 B7 54                 lda   [RgnPtrA],y              ; get second horizontal
0920 6DFB 85 2C                 sta   Temp+2                   ; save it
0921 6DFD C8 C8                 IncYWd                         ; bump y
0922 6DFF 84 C8                 sty   SrcY                     ; save offset pointer
0923 6E01
0924 6E01 A4 C6                 ldy   Index                    ; get index
0925 6E03 A5 2A                 lda   Temp                     ; get vert back
0926 6E05 97 C0                 sta   [BufPtr],y               ; put vert
0927 6E07 C8 C8                 IncYWd                         ; bump y
0928 6E09 8A                    txa                            ; get horizontal back
0929 6E0A 97 C0                 sta   [BufPtr],y               ; put horizontal
0930 6E0C C8 C8                 IncYWd                         ; bump y
0931 6E0E A5 2A                 lda   Temp                     ; get vert back
0932 6E10 97 C0                 sta   [BufPtr],y               ; put vert
0933 6E12 C8 C8                 IncYWd                         ; bump y
0934 6E14 A5 2C                 lda   Temp+2                   ; get second horizontal
0935 6E16 97 C0                 sta   [BufPtr],y               ; put second horizontal
0936 6E18 C8 C8                 IncYWd                         ; bump y
0937 6E1A 84 C6                 sty   Index                    ; save it
0938 6E1C
0939 6E1C A4 C8                 ldy   SrcY                     ; get source index
0940 6E1E 80 CF                 bra   NextHor                  ; look for more horizontal values
0941 6E20
0942 6E20                       ENDP 
0943 6E20
0944 6E20              ;                copy rgndefs/cullpoints
0945 6E20              ****************************************************************
0946 6E20              *
0947 6E20              * Procedure CullPoints; internal;
0948 6E20              *
0949 6E20              *   BufHandle is a pointer to a list of inversion points.  The
0950 6E20              *   zero page variable PtCount tells us how many there are
0951 6E20              *   at the moment.  Remove any duplicate points (which cancel
0952 6E20              *   each other) and update PtCount if necessary.
0953 6E20              *
0954 6E20              ****************************************************************
0955 6E20                       EXPORT iCullPoints 
0956 6E20              iCullPoints PROC 
0957 6E20
0958 6E20              * The buffer is stored in BufHandle and is already dereferenced
0959 6E20              * into BufPtr and is locked down.
0960 6E20
0961 6E20 A6 C4                 ldx   PtCount                  ; how many points to do?
0962 6E22 F0 17                 beq   DnCull                   ; if 0, well, that was easy
0963 6E24 A0 04 00              ldy   #4
0964 6E27 B7 C0                 lda   [BufPtr],y               ; set up the first points
0965 6E29 85 E0                 sta   PointV                   ; save it
0966 6E2B A0 06 00              ldy   #6                       ; point y a h
0967 6E2E B7 C0                 lda   [BufPtr],y               ; set up PointH
0968 6E30 85 E2                 sta   PointH                   ; save it
0969 6E32 A0 08 00              ldy   #8                       ; initial NextY value
0970 6E35 84 DC                 sty   NextY                    ; save it
0971 6E37 64 DA                 stz   Sluff                    ; sluff := false
0972 6E39 80 35                 bra   More                     ; let's do it
0973 6E3B
0974 6E3B 6B           DnCull   rtl                            ; get outa here
0975 6E3C
0976 6E3C A5 DA        CheckStarted lda   Sluff
0977 6E3E D0 08                 bne   ToEndCull
0978 6E40
0979 6E40              * Only the last two points need to be culled.  Set up DestY so
0980 6E40              * we can share common end code.
0981 6E40
0982 6E40 38                    sec   
0983 6E41 A5 DC                 lda   NextY
0984 6E43 E9 08 00              sbc   #8
0985 6E46 85 DE                 sta   DestY
0986 6E48 82 81 00     ToEndCull brl   EndCull                 ; help out short branch
0987 6E4B
0988 6E4B              * We get to Delete knowing it is time to delete a point.  We have
0989 6E4B              * to restore our environment to something sensible.  First, we
0990 6E4B              * decrement x twice.  If it's 0, we're done.  If not, we update
0991 6E4B              * NextY, PointV, and PointH.  Then if x=1 we jump ahead to LastPt.
0992 6E4B              * Y comes in equal to NextY
0993 6E4B
0994 6E4B CA           Delete   dex                            ; kill first point
0995 6E4C CA                    dex                            ; kill with second point
0996 6E4D F0 ED                 beq   CheckStarted             ; go do EndCull via ToEndCull
0997 6E4F
0998 6E4F              * at this point, y is pointing at H of NextY.  We must push it
0999 6E4F              * onwards by 6 bytes, and we know we can because the x register is
1000 6E4F              * not yet exhausted.  However, along the way we can use it to get
1001 6E4F              * the values of the current PointV,PointH.
1002 6E4F
1003 6E4F A5 DA                 lda   Sluff                    ; check our flag
1004 6E51 D0 0A                 bne   Started                  ; if <> 0, we've deleted something
1005 6E53 E6 DA                 inc   Sluff                    ; Sluff now <> 0
1006 6E55 A5 DC                 lda   NextY                    ; DestY := NextY-4
1007 6E57 38                    sec                            ; for subtract
1008 6E58 E9 08 00              sbc   #8                       ; decrement by 8
1009 6E5B 85 DE                 sta   DestY                    ; save correct value
1010 6E5D B7 C0        Started  lda   [BufPtr],y               ; get PointV
1011 6E5F 85 E0                 sta   PointV                   ; save it
1012 6E61 C8 C8                 IncYWd                         ; bump y by 2 to H offset
1013 6E63 B7 C0                 lda   [BufPtr],y               ; get PointH
1014 6E65 85 E2                 sta   PointH                   ; save it
1015 6E67 C8 C8                 IncYWd                         ; bump y by 2 to V offset
1016 6E69 84 DC                 sty   NextY                    ; save it in case x=1
1017 6E6B E0 01 00              cpx   #1                       ; is x=1?
1018 6E6E F0 40                 beq   SetupLastPt              ; go do lastpoint
1019 6E70
1020 6E70              * When we get to More, we have the current point stored in PointV and
1021 6E70              * PointH.  The y register points at the next entry.
1022 6E70
1023 6E70 A4 DC        More     ldy   NextY                    ; look at next point
1024 6E72 B7 C0                 lda   [BufPtr],y               ; get next point v
1025 6E74 85 2A                 sta   Temp                     ; save it
1026 6E76 C8 C8                 IncYWd                         ; bump to horizontal
1027 6E78 B7 C0                 lda   [BufPtr],y               ; fetch it
1028 6E7A 85 2C                 sta   Temp+2                   ; save it
1029 6E7C C8 C8                 IncYWd                         ; bump Y to next point
1030 6E7E 84 DC                 sty   NextY                    ; save pointer
1031 6E80 C5 E2                 cmp   PointH                   ; do horizontal first since A is set
1032 6E82 D0 06                 bne   HDiff                    ; if <>, save A and continue
1033 6E84 A5 2A                 lda   Temp
1034 6E86 C5 E0                 cmp   PointV
1035 6E88 F0 C1                 beq   Delete                   ; kill these points
1036 6E8A A5 DA        HDiff    lda   Sluff                    ; are we copying yet
1037 6E8C F0 10                 beq   NoCopy                   ; nope, not yet
1038 6E8E
1039 6E8E              * copy the old point back down
1040 6E8E
1041 6E8E A4 DE                 ldy   DestY                    ; get the next dest
1042 6E90 A5 E0                 lda   PointV                   ; get V
1043 6E92 97 C0                 sta   [BufPtr],y               ; store it
1044 6E94 C8 C8                 IncYWd                         ; bump y by 2
1045 6E96 A5 E2                 lda   PointH                   ; get H
1046 6E98 97 C0                 sta   [BufPtr],y               ; store it
1047 6E9A C8 C8                 IncYWd                         ; bump y by 2
1048 6E9C 84 DE                 sty   DestY                    ; save it
1049 6E9E
1050 6E9E CA           NoCopy   dex                            ; done with 1 point (or maybe two)
1051 6E9F F0 2B                 beq   EndCull                  ; tidy up if x=0
1052 6EA1 E0 01 00              cpx   #1                       ; is x=1?
1053 6EA4 F0 12                 beq   DoLastPt                 ; go do lastpoint
1054 6EA6
1055 6EA6              * we got here from the normal loop, so Temp contains the next point to
1056 6EA6              * use in the comparisons.  Copy it into PointV,PointH and start the loop.
1057 6EA6
1058 6EA6 A5 2A                 lda   Temp                     ; get next V
1059 6EA8 85 E0                 sta   PointV                   ; save it
1060 6EAA A5 2C                 lda   Temp+2                   ; get next H
1061 6EAC 85 E2                 sta   PointH                   ; save that too
1062 6EAE 80 C0                 bra   More                     ; start the loop again
1063 6EB0
1064 6EB0 A5 E0        SetupLastPt lda   PointV                ; we gonna use temp below
1065 6EB2 85 2A                 sta   Temp
1066 6EB4 A5 E2                 lda   PointH
1067 6EB6 85 2C                 sta   Temp+2
1068 6EB8 A5 DA        DoLastPt lda   Sluff                    ; check our flag
1069 6EBA F0 17                 beq   Nochange                 ; if nothing deleted by now, just leave
1070 6EBC A5 2A                 lda   Temp                     ; these should be set
1071 6EBE A4 DE                 ldy   DestY                    ; get destination offset
1072 6EC0 97 C0                 sta   [BufPtr],y               ; save it
1073 6EC2 A5 2C                 lda   Temp+2                   ; next value
1074 6EC4 C8 C8                 IncYWd                         ; bump y by 2
1075 6EC6 97 C0                 sta   [BufPtr],y               ; save it
1076 6EC8 C8 C8                 IncYWd                         ; for good measure
1077 6ECA 84 DE                 sty   DestY                    ; save it
1078 6ECC
1079 6ECC A5 DE        EndCull  lda   DestY                    ; points at next location
1080 6ECE 4A                    lsr   a                        ; divide by 2
1081 6ECF 4A                    lsr   a                        ; divided by 4
1082 6ED0 3A                    dec   a                        ; -1 for start
1083 6ED1 85 C4                 sta   PtCount                  ; updated PtCount
1084 6ED3 6B           NoChange rtl   
1085 6ED4
1086 6ED4                       ENDP 
1087 6ED4              ;                copy rgndefs/sortpoints
1088 6ED4              ****************************************************************
1089 6ED4              *
1090 6ED4              * Procedure SortPoints
1091 6ED4              *
1092 6ED4              *   Upon entering SortPoints, the list of inversion points to
1093 6ED4              *   be QuickSorted is found in RgnHandleA and RgnPtrA on zero
1094 6ED4              *   page.  The number of points is found in PtCount, also on
1095 6ED4              *   zero page.  This routine performs a QuickSort on the list
1096 6ED4              *   and uses log (base 2) n of stack space.  Since the list is
1097 6ED4              *   constrained to fit in one 64K bank (to accomodate the range
1098 6ED4              *   of the y register) we will need a maximum of log (base 2) 16K,
1099 6ED4              *   or 14, times the stack space per partition element (4 bytes)
1100 6ED4              *   or about 56 bytes.
1101 6ED4              *
1102 6ED4              ****************************************************************
1103 6ED4                       EXPORT iSortPoints 
1104 6ED4              iSortPoints PROC 
1105 6ED4
1106 6ED4              * The buffer is stored in BufHandle and is already dereferenced and
1107 6ED4              * locked down.
1108 6ED4
1109 6ED4 A0 04 00              ldy   #4                       ; start of list
1110 6ED7 84 D0                 sty   lptr                     ; save this ptr
1111 6ED9 A2 01 00              ldx   #1                       ; we'll put one entry on the stack
1112 6EDC 86 D8                 stx   SpCount                  ; one item on our stack
1113 6EDE 98                    tya                            ; stack[1].l := 1
1114 6EDF 48                    pha                            ; push it
1115 6EE0 A5 C4                 lda   PtCount                  ; stack[1].r := PtCount
1116 6EE2 0A                    asl   a                        ; multiply by 2
1117 6EE3 0A                    asl   a                        ; multiply by 4 (includes -4 offset)
1118 6EE4 48                    pha                            ; push it
1119 6EE5
1120 6EE5              * repeat { pop top request from stack }
1121 6EE5              * ..lptr := a[s].l; rptr := a[s].r
1122 6EE5
1123 6EE5 68           PopNext  pla                            ; pop right
1124 6EE6 85 D2                 sta   rptr                     ; new zero page
1125 6EE8 68                    pla                            ; pop left
1126 6EE9 85 D0                 sta   lptr                     ; new zero page
1127 6EEB C6 D8                 dec   SpCount                  ; decrement stack count
1128 6EED
1129 6EED              * ..repeat { split a[l] ... a[r] }
1130 6EED              * ....iptr := lptr; j := rptr; Mid(V,H) := a[(l+r) div 2](V,H);
1131 6EED
1132 6EED A5 D0        Split    lda   lptr                     ; get lptr
1133 6EEF 85 C6                 sta   iptr                     ; store in iptr
1134 6EF1 A5 D2                 lda   rptr                     ; get rptr
1135 6EF3 85 C8                 sta   jptr                     ; store in jptr
1136 6EF5 18                    clc                            ; clear carry
1137 6EF6 65 C6                 adc   iptr                     ; add both
1138 6EF8 6A                    ror   a                        ; divide by 2 with carry from add
1139 6EF9 29 FC FF              and   #$FFFC                   ; put back onto a point boundary
1140 6EFC
1141 6EFC              * A contains the y index into the point buffer.  Load the actual key
1142 6EFC              * values Point[y div 4].(V,H) into MidV and MidH.
1143 6EFC
1144 6EFC A8                    tay                            ; put index into y
1145 6EFD B7 C0                 lda   [BufPtr],y               ; get MidV
1146 6EFF 85 D4                 sta   MidV                     ; save it
1147 6F01 C8                    iny                            ; bump y
1148 6F02 C8                    iny                            ; bump y
1149 6F03 B7 C0                 lda   [BufPtr],y               ; get MidH
1150 6F05 85 D6                 sta   MidH                     ; save it
1151 6F07
1152 6F07              * ....repeat { scan for keys out of order, then swap }
1153 6F07
1154 6F07              * Scan the partition for points out of order with respect to a
1155 6F07              * screening point randomly selected in the middle.  First scan
1156 6F07              * upwards from iptr, then downwards from jptr, to set the limits
1157 6F07              * of a partition which is out of order.
1158 6F07
1159 6F07 A4 C6        Scan     ldy   iptr                     ; load iptr into y
1160 6F09 A5 D4                 lda   MidV                     ; get screening value
1161 6F0B 80 04                 bra   ScanIEntry               ; skip around increment
1162 6F0D
1163 6F0D              * ......while a[iptr] < Mid do iptr := iptr+1
1164 6F0D
1165 6F0D C8 C8 C8 C8  NextIScan IncYPtr                       ; bump y to next point
1166 6F11 D7 C0        ScanIEntry cmp   [BufPtr],y             ; set flags on MidV-pts[iptr].v
1167 6F13 30 16                 bmi   Scan2                    ; if we had to borrow, we've found
1168 6F15 D0 F6                 bne   NextIScan                ; if plus, look at the next one
1169 6F17 A5 D6                 lda   MidH                     ; get screening value
1170 6F19 C8 C8                 IncYWd                         ; bump y to h value
1171 6F1B D7 C0                 cmp   [BufPtr],y               ; set flags on MidH-pts[iptr].h
1172 6F1D 30 08                 bmi   Scan2a                   ; if we had to borrow, we've found
1173 6F1F F0 06                 beq   Scan2a                   ; or if equal, we're still done
1174 6F21 C8 C8                 IncYWd                         ; point iptr at next entry
1175 6F23 A5 D4                 lda   MidV                     ; reload A
1176 6F25 80 EA                 bra   ScanIEntry               ; jump back and continue scanning
1177 6F27
1178 6F27              * note that A still	contains MidV
1179 6F27
1180 6F27 88 88        Scan2a   DecYWd                         ; remove h value bump
1181 6F29 A5 D4                 lda   MidV                     ; reload v value
1182 6F2B 84 C6        Scan2    sty   iptr                     ; save iptr away
1183 6F2D A4 C8                 ldy   jptr                     ; get jptr value into y
1184 6F2F 80 04                 bra   ScanJEntry               ; skip around decrement
1185 6F31
1186 6F31              * ......while a[jptr] > Mid do jptr := jptr-1
1187 6F31
1188 6F31 88 88 88 88  NextJScan DecYPtr                       ; dec y to next point
1189 6F35 D7 C0        ScanJEntry cmp   [BufPtr],y             ; set flags on MidV-pts[jptr].v
1190 6F37 30 F8                 bmi   NextJScan                ; if we borrowed, look at next
1191 6F39              * The Order and PreOrder entry points need to be checked
1192 6F39 D0 14                 bne   Order                    ; if Midv > pts.v, look again
1193 6F3B A5 D6                 lda   MidH                     ; get screening value
1194 6F3D C8 C8                 IncYWd                         ; bump y to h value
1195 6F3F D7 C0                 cmp   [BufPtr],y               ; set flags on MidH-pts[jptr].h
1196 6F41 10 0A                 bpl   PreOrder                 ; if carry set we've found it
1197 6F43 98                    tya                            ; put jptr in A
1198 6F44 38                    sec                            ; set carry before subtract
1199 6F45 E9 06 00              sbc   #6                       ; decrement by 6
1200 6F48 A8                    tay                            ; put it back into y
1201 6F49 A5 D4                 lda   MidV                     ; restore A
1202 6F4B 80 E8                 bra   ScanJEntry               ; loop again
1203 6F4D
1204 6F4D              * If Iptr <= Jptr bump both pointers.  If Iptr < Jptr, swap them (Quickdraw
1205 6F4D              * always swapped them.  Let's save a few instructions).
1206 6F4D
1207 6F4D              * ......if i < j then { swap a[jptr] and a[iptr] }
1208 6F4D
1209 6F4D 88 88        PreOrder DecYWd                         ; put counter back by 2
1210 6F4F 84 C8        Order    sty   jptr                     ; save y in jptr
1211 6F51 C4 C6                 cpy   iptr                     ; set flags on jptr-iptr
1212 6F53 90 43                 bcc   DnScan                   ; Yes, all done
1213 6F55 F0 2A                 beq   NextIJ                   ; if same point, bump but don't swap
1214 6F57 B7 C0                 lda   [BufPtr],y               ; get point V
1215 6F59 85 2A                 sta   Temp                     ; save it
1216 6F5B C8 C8                 IncYWd                         ; bump y by 2
1217 6F5D B7 C0                 lda   [BufPtr],y               ; get point H
1218 6F5F 85 2C                 sta   Temp+2                   ; save it also
1219 6F61 A4 C6                 ldy   iptr                     ; get other point
1220 6F63 B7 C0                 lda   [BufPtr],y               ; get point V
1221 6F65 AA                    tax                            ; save it in x
1222 6F66 C8 C8                 IncYWd                         ; bump y by 2
1223 6F68 B7 C0                 lda   [BufPtr],y               ; get point H
1224 6F6A A4 C8                 ldy   jptr                     ; get jptr back
1225 6F6C C8 C8                 IncYWd                         ; bump y to H part
1226 6F6E 97 C0                 sta   [BufPtr],y               ; save point H
1227 6F70 8A                    txa                            ; get v back
1228 6F71 88 88                 DecYWd                         ; bump y down to V part
1229 6F73 97 C0                 sta   [BufPtr],y               ; save point V
1230 6F75 A4 C6                 ldy   iptr                     ; get iptr back
1231 6F77 A5 2A                 lda   Temp                     ; get V point
1232 6F79 97 C0                 sta   [BufPtr],y               ; store V part
1233 6F7B C8 C8                 IncYWd                         ; bump y to H part
1234 6F7D A5 2C                 lda   Temp+2                   ; get H part
1235 6F7F 97 C0                 sta   [BufPtr],y               ; store V part
1236 6F81 A4 C6        NextIJ   ldy   iptr                     ; get iptr
1237 6F83 C8 C8 C8 C8           IncYPtr                        ; bump it
1238 6F87 84 C6                 sty   iptr                     ; save it
1239 6F89 A4 C8                 ldy   jptr                     ; get jptr
1240 6F8B 88 88 88 88           DecYPtr                        ; decrement it
1241 6F8F 84 C8                 sty   jptr                     ; save it
1242 6F91 C4 C6                 cpy   iptr                     ; set flags on jptr-iptr
1243 6F93 90 03                 bcc   DnScan                   ; if iptr > jptr, we're done
1244 6F95 4C 07 6F              jmp   Scan                     ; continue sorting
1245 6F98
1246 6F98              * ......until iptr > jptr
1247 6F98
1248 6F98 38           DnScan   sec   
1249 6F99 A5 D2                 lda   rptr                     ; compute rptr - iptr
1250 6F9B E5 C6                 sbc   iptr                     ;
1251 6F9D 85 2A                 sta   temp                     ; save it
1252 6F9F 38                    sec                            ; set carry again
1253 6FA0 A5 C8                 lda   jptr                     ; compute jptr - lptr
1254 6FA2 E5 D0                 sbc   lptr                     ;
1255 6FA4 C5 2A                 cmp   temp                     ; set flags on (jptr-lptr)-(rptr-iptr)
1256 6FA6 B0 12                 bcs   AddLeft                  ; if (jptr-lptr) >= (rptr-iptr) do left
1257 6FA8 A5 C6        AddRight lda   iptr                     ; get iptr
1258 6FAA C5 D2                 cmp   rptr                     ; set flags on iptr-rptr
1259 6FAC B0 06                 bcs   NoRAdd                   ; if rptr > iptr then add partition
1260 6FAE E6 D8                 inc   SpCount                  ; bump our stack counter
1261 6FB0 48                    pha                            ; push iptr
1262 6FB1 A5 D2                 lda   rptr                     ; get rptr
1263 6FB3 48                    pha                            ; push that too
1264 6FB4 A5 C8        NoRAdd   lda   jptr                     ; set rptr := jptr below
1265 6FB6 85 D2                 sta   rptr                     ; do it
1266 6FB8 80 10                 bra   RJoin                    ; catch up below
1267 6FBA
1268 6FBA A5 D0        AddLeft  lda   lptr                     ; get lptr
1269 6FBC C5 C8                 cmp   jptr                     ; set flags on lptr-jptr
1270 6FBE B0 06                 bcs   NoLAdd                   ; if jptr > lptr then add partition
1271 6FC0 E6 D8                 inc   SpCount                  ; bump our stack counter
1272 6FC2 48                    pha                            ; push lptr
1273 6FC3 A5 C8                 lda   jptr                     ; get jptr
1274 6FC5 48                    pha                            ; push that too
1275 6FC6 A5 C6        NoLAdd   lda   iptr                     ; get iptr
1276 6FC8 85 D0                 sta   lptr                     ; lptr := iptr
1277 6FCA
1278 6FCA              * ....until lptr >= rptr
1279 6FCA
1280 6FCA A5 D0        RJoin    lda   lptr                     ; get lptr
1281 6FCC C5 D2                 cmp   rptr                     ; set flags on lptr-rptr
1282 6FCE B0 03                 bcs   DnSplit                  ; done if rptr > lptr
1283 6FD0 4C ED 6E              jmp   Split                    ; split again and continue sorting
1284 6FD3
1285 6FD3              * ..until s=0
1286 6FD3
1287 6FD3 A5 D8        DnSplit  lda   SpCount                  ; get our stack counter
1288 6FD5 F0 03                 beq   DnPop                    ; if 0, we're through
1289 6FD7 4C E5 6E              jmp   PopNext                  ; if not, sort the next partition
1290 6FDA
1291 6FDA 6B           DnPop    rtl                            ; let's go home!
1292 6FDB
1293 6FDB                       ENDP 
1294 6FDB              ;                copy rgndefs/packrgn
1295 6FDB              ****************************************************************
1296 6FDB              *
1297 6FDB              * Procedure PackRgn;
1298 6FDB              *
1299 6FDB              * Converts a sorted array of inversion points into a region.
1300 6FDB              * Calls storage allocator to make more room and trim result to
1301 6FDB              * minimum size.  Output is in the following form:
1302 6FDB              *
1303 6FDB              *    Rgnsize             (minimum 10 bytes)
1304 6FDB              *    RgnBBox             (bounding box, top:left:bottom:right)
1305 6FDB              *    V1 H1,...,Hn Maxint (scan line, inv.pts on that line)
1306 6FDB              *    V2 H1,...,Hm Maxint (next scan line where inv.pts. change)
1307 6FDB              *    ...
1308 6FDB              *    Maxint              (no more scan lines)
1309 6FDB              *
1310 6FDB              * The array of inversion points is in BufHandle and BufPtr.
1311 6FDB              * The number of points is in PtCount, and the destination region
1312 6FDB              * handle is passed in RgnHandleA and RgnPtrA.
1313 6FDB              *
1314 6FDB              ****************************************************************
1315 6FDB                       EXPORT iPackRgn 
1316 6FDB              iPackRgn PROC 
1317 6FDB
1318 6FDB A9 0A 00              lda   #10                      ; minimum length region
1319 6FDE 87 54                 sta   [RgnPtrA]                ; zero the region
1320 6FE0 A9 00 00              lda   #0                       ; for clearing
1321 6FE3 A0 02 00              ldy   #2                       ; offset to top
1322 6FE6 97 54                 sta   [RgnPtrA],y              ; top := 0
1323 6FE8 A0 04 00              ldy   #4                       ; offset to left
1324 6FEB 97 54                 sta   [RgnPtrA],y              ; left := 0
1325 6FED A0 06 00              ldy   #6                       ; offset to bottom
1326 6FF0 97 54                 sta   [RgnPtrA],y              ; bottom := 0
1327 6FF2 A0 08 00              ldy   #8                       ; offset to right
1328 6FF5 97 54                 sta   [RgnPtrA],y              ; right := 0
1329 6FF7 A9 04 00              lda   #4                       ; examine point count
1330 6FFA C5 C4                 cmp   PtCount                  ; set flags on 4-PtCount
1331 6FFC 90 2E                 bcc   NotRect                  ; if PtCount > 4, we have more work
1332 6FFE D0 26                 bne   DnRect                   ; if PtCount <> 4, leave as null region
1333 7000              * Move point at [BufPtr]+4 to BBox.TopLeft, [BufPtr]+12 to BBox.BotRight
1334 7000 A8                    tay                            ; y := 4, offset to top
1335 7001 B7 C0                 lda   [BufPtr],y               ; get top
1336 7003 A0 02 00              ldy   #2                       ; BBox.Top offset
1337 7006 97 54                 sta   [RgnPtrA],y              ; set top
1338 7008 A0 06 00              ldy   #6                       ; offset to left
1339 700B B7 C0                 lda   [BufPtr],y               ; get it
1340 700D A0 04 00              ldy   #4                       ; BBox.Left offset
1341 7010 97 54                 sta   [RgnPtrA],y              ; set left
1342 7012 A0 10 00              ldy   #16                      ; offset to bottom
1343 7015 B7 C0                 lda   [BufPtr],y               ; get it
1344 7017 A0 06 00              ldy   #6                       ; BBox.Bottom offset
1345 701A 97 54                 sta   [RgnPtrA],y              ; set bottom
1346 701C A0 12 00              ldy   #18                      ; offset to right
1347 701F B7 C0                 lda   [BufPtr],y               ; get it
1348 7021 A0 08 00              ldy   #8                       ; BBox.Right offset
1349 7024 97 54                 sta   [RgnPtrA],y              ; set right
1350 7026 A0 0A 00     DnRect   ldy   #10                      ; minimum region length
1351 7029 4C DE 70              jmp   TidyUp                   ; fix up size
1352 702C
1353 702C              * BBox.Top := Point[1].V
1354 702C
1355 702C A0 04 00     NotRect  ldy   #4                       ; offset to first point v
1356 702F B7 C0                 lda   [BufPtr],y               ; get it
1357 7031 A0 02 00              ldy   #2                       ; offset to BBox.Top
1358 7034 97 54                 sta   [RgnPtrA],y              ; save it
1359 7036 A0 06 00              ldy   #6                       ; offset to first point.h
1360 7039 B7 C0                 lda   [BufPtr],y               ; get it
1361 703B 85 CA                 sta   MinH                     ; MinH := Point[1].H
1362 703D 85 CC                 sta   MaxH                     ; MaxH := Point[1].H
1363 703F              * Y is still 6
1364 703F A6 C4                 ldx   PtCount                  ; x will be our loop counter
1365 7041 CA           Scan     Dex                            ; any points left?
1366 7042 F0 16                 beq   EndScan                  ; if not, quit scanning
1367 7044 C8 C8 C8 C8           IncYPtr                        ; bump y to next point
1368 7048 B7 C0                 lda   [BufPtr],y               ; get next point
1369 704A C5 CA                 cmp   MinH                     ; set flags on H-MinH
1370 704C 10 04                 bpl   TryMax                   ; if H >= MinH, check max
1371 704E 85 CA                 sta   MinH                     ; MinH := H
1372 7050 80 EF                 bra   Scan                     ; continue
1373 7052 C5 CC        TryMax   cmp   MaxH                     ; set flags on H-MaxH
1374 7054 30 EB                 bmi   Scan                     ; if H < MaxH, we're cool
1375 7056 85 CC                 sta   MaxH                     ; if H <= MaxH, MaxH := H
1376 7058 80 E7                 bra   Scan
1377 705A
1378 705A A0 04 00     EndScan  ldy   #4                       ; BBox.Left offset
1379 705D A5 CA                 lda   MinH                     ; get minimum H
1380 705F 97 54                 sta   [RgnPtrA],y              ; set left
1381 7061 A0 08 00              ldy   #8                       ; BBox.Right offset
1382 7064 A5 CC                 lda   MaxH                     ; get maximum H
1383 7066 97 54                 sta   [RgnPtrA],y              ; set right
1384 7068 A5 C4                 lda   PtCount                  ; get PtCount
1385 706A 0A                    asl   a                        ; multiply by 2
1386 706B 0A                    asl   a                        ; multiply by 4
1387 706C A8                    tay                            ; put in y
1388 706D B7 C0                 lda   [BufPtr],y               ; get last point V (-4 offset built in)
1389 706F A0 06 00              ldy   #6                       ; BBox.Bottom offset
1390 7072 97 54                 sta   [RgnPtrA],y              ; save bottom
1391 7074
1392 7074              * Get PtCount, multiply by 4 and add 12 to get the maximum number of
1393 7074              * bytes we'll need to store the packed region.
1394 7074
1395 7074 A5 C4                 lda   PtCount                  ; get pointcount
1396 7076 1A                    inc   a                        ; by 1 to include stuff at beginning
1397 7077 0A                    asl   a                        ; multiply by 2
1398 7078 0A                    asl   a                        ; multiplied by 4
1399 7079 69 0C 00              adc   #12                      ; carry should be clear, add 12
1400 707C A2 50 00              ldx   #RgnHandleA              ; get offset to destination handle
1401 707F 20 3B 5B              jsr   ResizeHandle             ; resize A handle
1402 7082 B0 14                 bcs   ErrorHandler             ; if error set, quit
1403 7084 85 54                 sta   RgnPtrA                  ; save pointer
1404 7086 86 56                 stx   RgnPtrA+2
1405 7088 A0 04 00              ldy   #4                       ; offset to first inversion point
1406 708B 84 C6                 sty   iptr                     ; save it
1407 708D A9 0A 00              lda   #10                      ; offset to first stored point
1408 7090 85 C8                 sta   jptr                     ; save it
1409 7092 B7 C0                 lda   [BufPtr],y               ; get top
1410 7094 A6 C4                 ldx   PtCount                  ; x is our loop counter again
1411 7096 80 16                 bra   Start                    ; do it
1412 7098
1413 7098 6B           ErrorHandler rtl                        ; leave with A and carry intact
1414 7099
1415 7099 A4 C6        NextPt   ldy   iptr                     ; set y to iptr
1416 709B B7 C0                 lda   [BufPtr],y               ; examine V point
1417 709D C5 CE                 cmp   CurY                     ; set flags on V-CurrentY
1418 709F F0 1F                 beq   VSame                    ; if same, add H point
1419 70A1 84 C6                 sty   iptr                     ; save iptr
1420 70A3
1421 70A3 A4 C8                 ldy   jptr                     ; switch to jptr
1422 70A5 A9 FF 3F              lda   #MaxInt                  ; get end of row signal
1423 70A8 97 54                 sta   [RgnPtrA],y              ; put it
1424 70AA C8 C8                 IncYWd                         ; bump jptr
1425 70AC 84 C8                 sty   jptr                     ; and save it
1426 70AE
1427 70AE A4 C6        Start    ldy   iptr                     ; get iptr
1428 70B0 B7 C0                 lda   [BufPtr],y               ; get V point
1429 70B2 84 C6                 sty   iptr                     ; save iptr
1430 70B4
1431 70B4 A4 C8                 ldy   jptr                     ; get jptr
1432 70B6 85 CE                 sta   CurY                     ; keep track of it
1433 70B8 97 54                 sta   [RgnPtrA],y              ; put new V value
1434 70BA C8 C8                 IncYWd                         ; bump it to H offset
1435 70BC 84 C8                 sty   jptr                     ; and save it
1436 70BE
1437 70BE              * y should be pointing at a v offset when we get to VSame, either by falling
1438 70BE              * through from Start or branching here from NextPt
1439 70BE
1440 70BE A4 C6                 ldy   iptr                     ; get iptr
1441 70C0 C8 C8        VSame    IncYWd                         ; bump y to h offset
1442 70C2 B7 C0                 lda   [BufPtr],y               ; get h value
1443 70C4 C8 C8                 IncYWd                         ; bump iptr to V offset
1444 70C6 84 C6                 sty   iptr                     ; save iptr
1445 70C8
1446 70C8 A4 C8                 ldy   jptr                     ; get jptr
1447 70CA 97 54                 sta   [RgnPtrA],y              ; put H value
1448 70CC C8 C8                 IncYWd                         ; bump jptr
1449 70CE 84 C8                 sty   jptr                     ; save jptr
1450 70D0
1451 70D0 CA                    dex                            ; decrement our counter
1452 70D1 D0 C6                 bne   NextPt                   ; if x <> 0, do another point
1453 70D3
1454 70D3              * Put maxint twice as end of region marker.  Y register is still jptr
1455 70D3
1456 70D3 A9 FF 3F              lda   #MaxInt                  ; get Maxint signal
1457 70D6 97 54                 sta   [RgnPtrA],y              ; put signal end of scan line
1458 70D8 C8 C8                 IncYWd                         ; bump it to end of region
1459 70DA 97 54                 sta   [RgnPtrA],y              ; put signal end of region
1460 70DC C8 C8                 IncYWd                         ; y is now length of region
1461 70DE
1462 70DE 98           TidyUp   tya                            ; put y into A
1463 70DF A2 50 00              ldx   #RgnHandleA              ; offset to RgnHandleA
1464 70E2 20 3B 5B              jsr   ResizeHandle             ; resize it
1465 70E5 85 54                 sta   RgnPtrA                  ; save pointer
1466 70E7 86 56                 stx   RgnPtrA+2
1467 70E9
1468 70E9 6B                    rtl                            ; leave, and propogate any error
1469 70EA
1470 70EA                       ENDP 
1471 70EA              ;                copy rgndefs/makergn
1472 70EA              ****************************************************************
1473 70EA              *
1474 70EA              * Procedure OpenRgn;
1475 70EA              *
1476 70EA              * 3/29/89           mensch
1477 70EA              * Changed the error code reported for already open to $0430 like 
1478 70EA              * the bopok says...
1479 70EA              *
1480 70EA              ****************************************************************
1481 70EA                       EXPORT OpenRgn 
1482 70EA              OpenRgn  PROC 
1483 70EA              *              using RegionData
1484 70EA              *              using CoreDATA
1485 70EA
1486 70EA              OrigDirect equ   1
1487 70EA              RTL1     equ   OrigDirect+2
1488 70EA              RTL2     equ   RTL1+3
1489 70EA              Next     equ   RTL2+3
1490 70EA
1491 70EA              * get address of GrafPort into y
1492 70EA
1493 70EA 20 AA 0F              jsr   QDStart
1494 70ED
1495 70ED 20 45 6B              jsr   RgnSave                  ; are we already saving one?
1496 70F0 B0 40                 bcs   OpenError                ; yes, give him an error
1497 70F2 A0 96 00              ldy   #o_RgnSave+2             ; offset to high word
1498 70F5 B7 24                 lda   [PortRef],y              ; get next word
1499 70F7 D0 39                 bne   OpenError                ; and complain again
1500 70F9 A2 BC 00              ldx   #BufHandle               ; place to put new handle
1501 70FC A9 00 01              lda   #256                     ; initial size to allocate
1502 70FF 20 62 5B              jsr   GetNewHandle             ; get us a new buffer
1503 7102 B0 2A                 bcs   HandleError              ; handle any error we find
1504 7104 85 C0                 sta   BufPtr                   ; save pointer
1505 7106 86 C2                 stx   BufPtr+2
1506 7108 A5 BC                 lda   BufHandle                ; get low word of handle
1507 710A A0 94 00              ldy   #o_RgnSave               ; offset to store it in grafport
1508 710D 97 24                 sta   [PortRef],y              ; store into RgnSave
1509 710F A5 BE                 lda   BufHandle+2              ; get high word
1510 7111 A0 96 00              ldy   #o_RgnSave+2             ; offset to high word in grafport
1511 7114 97 24                 sta   [PortRef],y              ; store into RgnSave+2
1512 7116 A0 02 00              ldy   #2                       ; index offset
1513 7119 A9 04 00              lda   #4                       ; initial length (0 points)
1514 711C 97 C0                 sta   [BufPtr],y               ; set first available offset
1515 711E A2 BC 00              ldx   #BufHandle               ; get offset to BufHandle
1516 7121 20 28 5B              jsr   UnLockHandle             ; unlock the handle
1517 7124 A2 04 27 22           _HidePen                       ; hide the pen
1518 712B 4C EA FB              jmp   BusyEC0
1519 712E
1520 712E AA           HandleError tax                         ; propogate the error
1521 712F 4C ED FB              jmp   BusyErr0
1522 7132
1523 7132              OpenError  
1524 7132 A2 30 04              ldx   #RgnAlreadyOpen          ; get error code
1525 7135              ;	ldx	#$4031	; WHY IS THIS HERE?
1526 7135 4C ED FB              jmp   BusyErr0                 ; tell him about it
1527 7138
1528 7138                       ENDP 
1529 7138
1530 7138              ****************************************************************
1531 7138              *
1532 7138              * Procedure CloseRgn(
1533 7138              *   dstRgn : RgnHandle
1534 7138              *   )
1535 7138              *
1536 7138              ****************************************************************
1537 7138              CloseRgn PROC EXPORT 
1538 7138
1539 7138              OrigDirect equ   1
1540 7138              RTL1     equ   OrigDirect+2
1541 7138              RTL2     equ   RTL1+3
1542 7138              dstRgn   equ   RTL2+3
1543 7138
1544 7138 20 AA 0F              jsr   QDStart
1545 713B
1546 713B 20 45 6B              jsr   RgnSave                  ; are we saving one?
1547 713E
1548 713E B0 05                 bcs   @Continue
1549 7140 A9 31 04              lda   #rgnNotOpen
1550 7143 80 75                 bra   HandleError
1551 7145
1552 7145              @Continue  
1553 7145 A9 00 00              lda   #0                       ; prepare for clear
1554 7148 A0 94 00              ldy   #o_RgnSave               ; offset to low word
1555 714B 97 24                 sta   [PortRef],y              ; zero lo word of old handle
1556 714D A0 96 00              ldy   #o_RgnSave+2             ; offset to RgnSave+2 in PortRef
1557 7150 97 24                 sta   [PortRef],y              ; zero hi word of old handle
1558 7152 A2 04 28 22           _ShowPen                       ; undo the HidePen from OpenRgn
1559 7159 A2 BC 00              ldx   #BufHandle               ; get offset to BufHandle
1560 715C 20 0D 5B              jsr   DerefHandle              ; dereference and lock
1561 715F 85 C0                 sta   BufPtr                   ; save pointer
1562 7161 86 C2                 stx   BufPtr+2
1563 7163 A0 02 00              ldy   #2                       ; get index offset
1564 7166 B7 C0                 lda   [BufPtr],y               ; get index
1565 7168 4A                    lsr   a                        ; divided by 2
1566 7169 4A                    lsr   a                        ; divided by 4
1567 716A 3A                    dec   a                        ; minus 1, now it's the # of points
1568 716B 85 C4                 sta   PtCount                  ; keeps our current point count
1569 716D A3 09                 lda   DstRgn,s                 ; get DstRgn handle
1570 716F 85 50                 sta   RgnHandleA               ; save it
1571 7171 A3 0B                 lda   DstRgn+2,s               ; get DstRgn handle hi word
1572 7173 85 52                 sta   RgnHandleA+2             ; save it too
1573 7175 A2 50 00              ldx   #RgnHandleA              ; get offset to RgnHandleA
1574 7178 20 0D 5B              jsr   DerefHandle              ; dereference it
1575 717B 85 54                 sta   RgnPtrA                  ; save pointer
1576 717D 86 56                 stx   RgnPtrA+2
1577 717F 22 90 1F E0           jsl   SortPoints               ; quicksort in VH order
1578 7183 22 8C 1F E0           jsl   CullPoints               ; cancel duplicate pairs
1579 7187 22 94 1F E0           jsl   PackRgn                  ; pack points into RgnHandleA (DstRgn)
1580 718B 64 C4                 stz   PtCount                  ; clear PackRgn error flag
1581 718D 90 04                 bcc   PackOkay
1582 718F E6 C4                 inc   PtCount                  ; save error condition
1583 7191 85 BA                 sta   Op                       ; save error code
1584 7193 A2 BC 00     PackOkay ldx   #BufHandle               ; get offset
1585 7196 20 28 5B              jsr   UnLockHandle             ; unlock the buffer
1586 7199 A2 50 00              ldx   #RgnHandleA              ; get offset
1587 719C 20 28 5B              jsr   UnLockHandle             ; unlock this too
1588 719F A5 BE 48 A5           PushLong BufHandle             ; push buffer handle
1589 71A5 A2 02 10 22           _DisposeHandle 
1590 71AC A4 C4                 ldy   PtCount                  ; see if we got a PackRgn error first
1591 71AE F0 05                 beq   NoPackErr                ; nope, look for a dispose error
1592 71B0 A6 BA                 ldx   Op
1593 71B2 4C 1C FC              jmp   BusyErr4
1594 71B5
1595 71B5 B0 03        NoPackErr bcs   HandleError             ; if carry set, it didn't work
1596 71B7 4C 19 FC     CloseDone jmp   BusyEC4
1597 71BA
1598 71BA AA           HandleError tax   
1599 71BB 4C 1C FC              jmp   BusyErr4
1600 71BE
1601 71BE                       ENDP 
1602 71BE
1603 71BE              ;                copy rgndefs/rgnscan
1604 71BE              ****************************************************************
1605 71BE              *
1606 71BE              * Procedure ExpandA
1607 71BE              *
1608 71BE              ****************************************************************
1609 71BE                       EXPORT ExpandA 
1610 71BE              ExpandA  PROC 
1611 71BE
1612 71BE A9 0A 00              lda   #10                      ; size of rectangular region
1613 71C1 C7 54                 cmp   [RgnPtrA]                ; set flags on 10-length
1614 71C3 D0 49                 bne   NotRect                  ; if not Rect, deal with that
1615 71C5 A5 E0 85 D0           Movelong Scratch,PtrBaseA      ; pointer to first fake region
1616 71CD
1617 71CD A0 02 00              ldy   #2
1618 71D0 B7 54                 lda   [RgnPtrA],y              ; BBox.Top
1619 71D2 87 D0                 sta   [PtrBaseA]               ; V 1
1620 71D4 A0 04 00              ldy   #4
1621 71D7 B7 54                 lda   [RgnPtrA],y              ; BBox.Left
1622 71D9 A0 02 00              ldy   #2
1623 71DC 97 D0                 sta   [PtrBaseA],y             ; H 1.1
1624 71DE A0 0A 00              ldy   #10
1625 71E1 97 D0                 sta   [PtrBaseA],y             ; H 2.1
1626 71E3 A0 06 00              ldy   #6
1627 71E6 B7 54                 lda   [RgnPtrA],y              ; BBox.Bottom
1628 71E8 A0 08 00              ldy   #8
1629 71EB 97 D0                 sta   [PtrBaseA],y             ; V 2
1630 71ED B7 54                 lda   [RgnPtrA],y              ; BBox.RIght
1631 71EF A0 04 00              ldy   #4
1632 71F2 97 D0                 sta   [PtrBaseA],y             ; H 1.2
1633 71F4 A0 0C 00              ldy   #12
1634 71F7 97 D0                 sta   [PtrBaseA],y             ; H 2.2
1635 71F9 A9 FF 3F              lda   #MaxInt
1636 71FC A0 06 00              ldy   #6
1637 71FF 97 D0                 sta   [PtrBaseA],y             ; store MaxInt
1638 7201 A0 0E 00              ldy   #14
1639 7204 97 D0                 sta   [PtrBaseA],y             ; store MaxInt
1640 7206 A0 10 00              ldy   #16
1641 7209 97 D0                 sta   [PtrBaseA],y             ; store MaxInt
1642 720B 64 D4                 stz   PtrA                     ; zero PtrA
1643 720D 60                    rts                            ; get outa here
1644 720E
1645 720E A5 54 85 D0  NotRect  Movelong RgnPtrA,PtrBaseA      ; use the actual pointer
1646 7216 A9 0A 00              lda   #10                      ; get offset to data
1647 7219 85 D4                 sta   PtrA                     ; save it
1648 721B 60                    rts                            ; get outa here
1649 721C
1650 721C                       ENDP 
1651 721C
1652 721C              ****************************************************************
1653 721C              *
1654 721C              * Procedure ExpandB
1655 721C              *
1656 721C              ****************************************************************
1657 721C                       EXPORT ExpandB 
1658 721C              ExpandB  PROC 
1659 721C
1660 721C              FakeOff  equ   18                       ; offset in Scratch to FakeB
1661 721C
1662 721C A9 0A 00              lda   #10                      ; size of rectangular region
1663 721F C7 64                 cmp   [RgnPtrB]                ; set flags on 10-length
1664 7221 D0 52                 bne   NotRect                  ; if not Rect, deal with that
1665 7223 A5 E0 85 D6           Movelong Scratch,PtrBaseB      ; point us at Scratch region
1666 722B
1667 722B A0 02 00              ldy   #2                       ; offset to BBox
1668 722E B7 64                 lda   [RgnPtrB],y              ; BBox.Top
1669 7230 A0 12 00              ldy   #FakeOff
1670 7233 97 D6                 sta   [PtrBaseB],y             ; V 1
1671 7235 A0 04 00              ldy   #4
1672 7238 B7 64                 lda   [RgnPtrB],y              ; BBox.Left
1673 723A A0 14 00              ldy   #2+FakeOff
1674 723D 97 D6                 sta   [PtrBaseB],y             ; H 1.1
1675 723F A0 1C 00              ldy   #10+FakeOff
1676 7242 97 D6                 sta   [PtrBaseB],y             ; H 2.1
1677 7244 A0 06 00              ldy   #6
1678 7247 B7 64                 lda   [RgnPtrB],y              ; BBox.Bottom
1679 7249 A0 1A 00              ldy   #8+FakeOff
1680 724C 97 D6                 sta   [PtrBaseB],y             ; V 2
1681 724E A0 08 00              ldy   #8
1682 7251 B7 64                 lda   [RgnPtrB],y              ; BBox.RIght
1683 7253 A0 16 00              ldy   #4+FakeOff
1684 7256 97 D6                 sta   [PtrBaseB],y             ; H 1.2
1685 7258 A0 1E 00              ldy   #12+FakeOff
1686 725B 97 D6                 sta   [PtrBaseB],y             ; H 2.2
1687 725D A9 FF 3F              lda   #MaxInt
1688 7260 A0 18 00              ldy   #6+FakeOff
1689 7263 97 D6                 sta   [PtrBaseB],y             ; store MaxInt
1690 7265 A0 20 00              ldy   #14+FakeOff
1691 7268 97 D6                 sta   [PtrBaseB],y             ; store MaxInt
1692 726A A0 22 00              ldy   #16+FakeOff
1693 726D 97 D6                 sta   [PtrBaseB],y             ; store MaxInt
1694 726F A9 12 00              lda   #FakeOff                 ; get fake offset
1695 7272 85 DA                 sta   PtrB                     ; offset to B
1696 7274 60                    rts                            ; get outa here
1697 7275
1698 7275 A5 64 85 D6  NotRect  Movelong RgnPtrB,PtrBaseB      ; use the real region
1699 727D A9 0A 00              lda   #10                      ; get offset to data
1700 7280 85 DA                 sta   PtrB                     ; save it
1701 7282 60                    rts                            ; get out here
1702 7283
1703 7283                       ENDP 
1704 7283
1705 7283              ****************************************************************
1706 7283              *
1707 7283              * Procedure SectScan
1708 7283              *
1709 7283              *   Accepts offsets into Scratch buffer in Src1, Src2, and
1710 7283              *   Dst.  It then calculates the intersection, difference,
1711 7283              *   or union of two inversion scans.  Each input scan is a
1712 7283              *   sorted array of integers terminated by MaxInt.  The output
1713 7283              *   scan contains the inversion coordinates for the result.
1714 7283              *
1715 7283              ****************************************************************
1716 7283                       EXPORT SectScan 
1717 7283              SectScan PROC 
1718 7283
1719 7283 64 7C                 stz   State1                   ; reset State1 off
1720 7285 64 7E                 stz   State2                   ; reset State2 off
1721 7287 80 0E                 bra   Share                    ; share code
1722 7289
1723 7289                       EXPORT DiffScan 
1724 7289              DiffScan                                ;       
1725 7289 64 7C                 stz   State1                   ; reset State1 off
1726 728B A9 FF FF              lda   #$FFFF                   ; get "on"
1727 728E 80 05                 bra   Union2                   ; share code
1728 7290
1729 7290                       EXPORT UnionScan 
1730 7290              UnionScan                               ; 
1731 7290 A9 FF FF              lda   #$FFFF                   ; get "on"
1732 7293 85 7C                 sta   State1                   ; set State2 on
1733 7295 85 7E        Union2   sta   State2                   ; set State1 on
1734 7297
1735 7297 A4 F2        Share    ldy   Src1                     ; get Next1
1736 7299 B7 EE                 lda   [SrcBase1],y
1737 729B 85 78                 sta   Next1                    ; save it
1738 729D C8 C8                 IncYWd                         ; bump y
1739 729F 84 F2                 sty   Src1
1740 72A1
1741 72A1 A4 F4                 ldy   Src2                     ; get Next2
1742 72A3 B7 E0                 lda   [Scratch],y
1743 72A5 85 7A                 sta   Next2
1744 72A7 C8 C8                 IncYWd 
1745 72A9 84 F4                 sty   Src2
1746 72AB
1747 72AB A5 7A        Next     lda   Next2                    ; get Next2
1748 72AD C5 78                 cmp   Next1                    ; set flags on Next2-Next1
1749 72AF 30 5C                 bmi   Less2                    ; if Next2 < Next1, process 2nd
1750 72B1 D0 39                 bne   Less1                    ; if Next1 < Next2, process 1st
1751 72B3
1752 72B3 C9 FF 3F     Equal    cmp   #MaxInt                  ; is it MaxInt
1753 72B6 F0 77                 beq   Done                     ; if so, we're done
1754 72B8 A5 7C                 lda   State1                   ; get State1
1755 72BA C5 7E                 cmp   State2                   ; are states the same?
1756 72BC D0 0A                 bne   Skip0                    ; no, skip
1757 72BE
1758 72BE A5 78                 lda   Next1                    ; get it back
1759 72C0 A4 F6                 ldy   Dst                      ; get destination
1760 72C2 97 E0                 sta   [Scratch],y              ; put it
1761 72C4 C8 C8                 IncYWd                         ; bump y
1762 72C6 84 F6                 sty   Dst                      ; save Dst counter
1763 72C8
1764 72C8 A4 F2        Skip0    ldy   Src1                     ; get A ptr
1765 72CA B7 EE                 lda   [SrcBase1],y             ; get Next1
1766 72CC 85 78                 sta   Next1                    ; save it
1767 72CE C8 C8                 IncYWd                         ; bump y
1768 72D0 84 F2                 sty   Src1                     ; save y
1769 72D2
1770 72D2 A5 7C                 lda   State1                   ; get State1
1771 72D4 49 FF FF              eor   #$FFFF                   ; not #1
1772 72D7 85 7C                 sta   State1                   ; save it
1773 72D9
1774 72D9 A4 F4                 ldy   Src2                     ; get index
1775 72DB B7 E0                 lda   [Scratch],y              ; get Next2
1776 72DD 85 7A                 sta   Next2                    ; save it
1777 72DF C8 C8                 IncYWd                         ; bump y
1778 72E1 84 F4                 sty   Src2                     ; save y
1779 72E3
1780 72E3 A5 7E                 lda   State2                   ; get State2
1781 72E5 49 FF FF              eor   #$FFFF                   ; not #2
1782 72E8 85 7E                 sta   State2                   ; save it
1783 72EA 80 BF                 bra   Next                     ; loop for more
1784 72EC
1785 72EC A5 7E        Less1    lda   State2                   ; test State2
1786 72EE F0 0A                 beq   Skip1                    ; skip if not true
1787 72F0
1788 72F0 A5 78                 lda   Next1                    ; get A
1789 72F2 A4 F6                 ldy   Dst                      ; get destination
1790 72F4 97 E0                 sta   [Scratch],y              ; save it
1791 72F6 C8 C8                 IncYWd                         ; bump y
1792 72F8 84 F6                 sty   Dst                      ; save Dst
1793 72FA
1794 72FA A4 F2        Skip1    ldy   Src1
1795 72FC B7 EE                 lda   [SrcBase1],y             ; get next value
1796 72FE 85 78                 sta   Next1                    ; save it
1797 7300 C8 C8                 IncYWd                         ; bump y
1798 7302 84 F2                 sty   Src1                     ; save it
1799 7304
1800 7304 A5 7C                 lda   State1                   ; get state
1801 7306 49 FF FF              eor   #$FFFF                   ; not State1
1802 7309 85 7C                 sta   State1                   ; save it
1803 730B 80 9E                 bra   Next                     ; loop for more
1804 730D
1805 730D A5 7C        Less2    lda   State1                   ; test State1
1806 730F F0 0A                 beq   Skip2                    ; skip if not true
1807 7311
1808 7311 A5 7A                 lda   Next2                    ; get B
1809 7313 A4 F6                 ldy   Dst                      ; get destination
1810 7315 97 E0                 sta   [Scratch],y              ; save it
1811 7317 C8 C8                 IncYWd                         ; bump y
1812 7319 84 F6                 sty   Dst                      ; save Dst
1813 731B
1814 731B A4 F4        Skip2    ldy   Src2                     ; get Next2
1815 731D B7 E0                 lda   [Scratch],y              ; get next value
1816 731F 85 7A                 sta   Next2                    ; save it
1817 7321 C8 C8                 IncYWd                         ; bump y
1818 7323 84 F4                 sty   Src2                     ; save it
1819 7325
1820 7325 A5 7E                 lda   State2                   ; get state
1821 7327 49 FF FF              eor   #$FFFF                   ; not State2
1822 732A 85 7E                 sta   State2                   ; save it
1823 732C 4C AB 72              jmp   Next                     ; loop for more
1824 732F
1825 732F A9 FF 3F     Done     lda   #MaxInt                  ; get maxint
1826 7332 A4 F6                 ldy   Dst                      ; get pointer
1827 7334 97 E0                 sta   [Scratch],y              ; store end of scan
1828 7336 C8 C8 C8 C8           IncYPtr                        ; bump y
1829 733A 84 F6                 sty   Dst                      ; make count valid
1830 733C 60                    rts                            ; we're out of here
1831 733D
1832 733D                       ENDP 
1833 733D
1834 733D              ****************************************************************
1835 733D              *
1836 733D              * Procedure InsetScan
1837 733D              *
1838 733D              *   Accepts offsets into Scratch buffer in Src1 and
1839 733D              *   Dst.  It then horizontally insets an inversion scan by DH.
1840 733D              *   The input scan is a sorted array of integers terminated by
1841 733D              *   MaxInt.  The output scan contains the inversion coordinates
1842 733D              *   for the inset.
1843 733D              *
1844 733D              *   1/20/88 GCP Added test to outsetscan to check for equal points.
1845 733D              ****************************************************************
1846 733D                       EXPORT InsetScan 
1847 733D              InsetScan PROC 
1848 733D
1849 733D A5 B8                 lda   DH                       ; is dh negative?
1850 733F 30 41                 bmi   Outset                   ; yes, outset
1851 7341 A4 F2        Inset    ldy   Src1                     ; get first offset
1852 7343 B7 EE                 lda   [SrcBase1],y             ; get first value
1853 7345 85 2A                 sta   Temp                     ; save it
1854 7347 C9 FF 3F              cmp   #MaxInt                  ; check for terminator
1855 734A F0 2A                 beq   DoneOutSet               ; quit when found
1856 734C
1857 734C C8 C8                 IncYWd                         ; bump y
1858 734E B7 EE                 lda   [SrcBase1],y             ; get second value
1859 7350 C8 C8                 IncYWd                         ; bump y again
1860 7352 84 F2                 sty   Src1                     ; save it
1861 7354
1862 7354 38                    sec                            ; prepare for subtract
1863 7355 E5 B8                 sbc   DH                       ; subtract from right
1864 7357 85 2C                 sta   Temp+2                   ; save it also
1865 7359
1866 7359 A5 2A                 lda   Temp                     ; get first back
1867 735B 18                    clc                            ; prepare for add
1868 735C 65 B8                 adc   DH                       ; add to left
1869 735E 85 2A                 sta   Temp                     ; save it
1870 7360 C5 2C                 cmp   Temp+2                   ; set flags on left-right
1871 7362 10 DD                 bpl   Inset                    ; if left >= right, skip both
1872 7364
1873 7364 A4 F6                 ldy   Dst                      ; get destination offset
1874 7366 97 E0                 sta   [Scratch],y              ; save first
1875 7368 C8 C8                 IncYWd                         ; bump y
1876 736A A5 2C                 lda   Temp+2                   ; get first back
1877 736C 97 E0                 sta   [Scratch],y              ; save second
1878 736E C8 C8                 IncYWd                         ; bump y
1879 7370 84 F6                 sty   Dst                      ; save pointer
1880 7372
1881 7372 80 CD                 bra   Inset                    ; loop entire scan
1882 7374
1883 7374 84 F2        DoneOut  sty   Src1                     ; update it
1884 7376 A4 F6        DoneOutSet ldy   Dst                    ; get destination pointer
1885 7378 A9 FF 3F              lda   #MaxInt                  ; get end of scan
1886 737B 97 E0                 sta   [Scratch],y              ; mark it
1887 737D C8 C8                 IncYWd                         ; bump y
1888 737F 84 F6                 sty   Dst                      ; there!
1889 7381 60                    rts                            ; All done!
1890 7382
1891 7382              * each pair of coords, outset them and cancel if they cross
1892 7382
1893 7382 A9 01 C0     Outset   lda   #-MaxInt                 ; set oldright
1894 7385 85 80        OutsetLoop sta   OldRight               ; to -Maxint
1895 7387 A4 F2                 ldy   Src1                     ; get next offset
1896 7389 B7 EE                 lda   [SrcBase1],y             ; load next left value
1897 738B C8 C8                 IncYWd                         ; bump it
1898 738D 85 2A                 sta   Temp                     ; save it
1899 738F C9 FF 3F              cmp   #MaxInt                  ; check for terminator
1900 7392 F0 E0                 beq   DoneOut                  ; if it is, we're done
1901 7394 B7 EE                 lda   [SrcBase1],y             ; get right value
1902 7396 C8 C8                 IncYWd                         ; bump y
1903 7398 84 F2                 sty   Src1                     ; save it
1904 739A
1905 739A A4 F6                 ldy   Dst                      ; get ready for store
1906 739C 38                    sec                            ; prepare for subtract
1907 739D E5 B8                 sbc   DH                       ; right-DH
1908 739F 85 2C                 sta   Temp+2                   ; save it
1909 73A1 A5 2A                 lda   Temp                     ; get left back
1910 73A3 18                    clc                            ; prepare for add
1911 73A4 65 B8                 adc   DH                       ; add to left
1912 73A6 C5 80                 cmp   OldRight                 ; is left <= OldRight
1913 73A8 F0 02                 beq   Around
1914 73AA 10 04                 bpl   OutOk                    ; no, continue
1915 73AC 88 88        Around   DecYWd                         ; decrement Dst by 2
1916 73AE 80 04                 bra   OutOk2                   ; and continue
1917 73B0 97 E0        OutOk    sta   [Scratch],y              ; save left point
1918 73B2 C8 C8                 IncYWd                         ; bump y
1919 73B4 A5 2C        OutOk2   lda   Temp+2                   ; get right back
1920 73B6 97 E0                 sta   [Scratch],y              ; save right point
1921 73B8 C8 C8                 IncYWd                         ; bump y
1922 73BA 84 F6                 sty   Dst                      ; save it
1923 73BC 80 C7                 bra   OutsetLoop               ; loop for entire scan
1924 73BE
1925 73BE                       ENDP 
1926 73BE
1927 73BE              ****************************************************************
1928 73BE              *
1929 73BE              * Procedure XorScan
1930 73BE              *
1931 73BE              *   Accepts offsets into Scratch buffer in Src1, Src2, and
1932 73BE              *   Dst.  It then forms the exclusive or of two inversion scans.
1933 73BE              *   Each input scan is a sorted array of integers terminated by
1934 73BE              *   MaxInt.  The output scan contains all input coordinates from
1935 73BE              *   each, but with duplicate pairs cancelled.  It also is
1936 73BE              *   terminated by MaxInt.
1937 73BE              *
1938 73BE              * 3/7/89            Konstantin
1939 73BE              *
1940 73BE              *                   Removed variables Next1 and Next2, and made loops
1941 73BE              *                   tighter and faster.
1942 73BE              *
1943 73BE              ****************************************************************
1944 73BE                       EXPORT XorScan 
1945 73BE              XorScan  PROC 
1946 73BE A6 F6                 ldx   Dst
1947 73C0
1948 73C0 A4 F4                 ldy   Src2                     ; get offset to A
1949 73C2 B7 E0        DoNext   lda   [Scratch],y              ; get Next 
1950 73C4
1951 73C4 A4 F2                 ldy   Src1                     ; get next B offset
1952 73C6 D7 EE                 cmp   [SrcBase1],y             ; compare with next1
1953 73C8
1954 73C8 30 17                 bmi   Less2
1955 73CA D0 2C                 bne   Less1                    ; if Next1 < Next2, take from 1
1956 73CC
1957 73CC              Equal     
1958 73CC A4 F2                 ldy   Src1                     ;Worst case: 5 cycles
1959 73CE C8 C8                 IncYWd                         ;4 cycles
1960 73D0 84 F2                 sty   Src1                     ;Worst case: 5 cycles
1961 73D2
1962 73D2 A4 F4                 ldy   Src2
1963 73D4 C8 C8                 IncYWd 
1964 73D6 84 F4                 sty   Src2
1965 73D8
1966 73D8 C9 FF 3F              cmp   #MaxInt                  ; all done?
1967 73DB D0 E5                 bne   DoNext                   ;y-reg  contains Src2
1968 73DD
1969 73DD              XorScanDone  
1970 73DD 9B                    txy   
1971 73DE 97 E0                 sta   [Scratch],y              ; save terminator, y already = Dst
1972 73E0 60                    rts                            ; go home
1973 73E1
1974 73E1              Less2                                   ;a contains value pointed to by src2
1975 73E1 9B                    txy   
1976 73E2 97 E0                 sta   [Scratch],y              ; save the second value
1977 73E4 E8                    inx                            ; bump Dst
1978 73E5 E8                    inx                            ; and save it
1979 73E6
1980 73E6 A4 F4                 ldy   Src2                     ; get offset to A
1981 73E8 C8 C8                 IncYWd 
1982 73EA 84 F4                 sty   Src2
1983 73EC B7 E0                 lda   [Scratch],y              ; get Next A
1984 73EE
1985 73EE A4 F2                 ldy   Src1                     ; get next B offset
1986 73F0 D7 EE                 cmp   [SrcBase1],y             ; compare with next1
1987 73F2
1988 73F2 30 ED                 bmi   Less2
1989 73F4 D0 02                 bne   Less1                    ; if Next1 < Next2, take from 1
1990 73F6 80 D4                 bra   Equal
1991 73F8              Less1                                   ;y contains Src1
1992 73F8 B7 EE                 lda   [SrcBase1],y
1993 73FA C8 C8                 IncYWd 
1994 73FC 84 F2                 sty   Src1
1995 73FE
1996 73FE 9B                    txy   
1997 73FF 97 E0                 sta   [Scratch],y              ; put it
1998 7401 E8                    inx                            ; bump Dst
1999 7402 E8                    inx                            ; and save it
2000 7403
2001 7403 A4 F4                 ldy   Src2                     ; get offset to A
2002 7405 B7 E0                 lda   [Scratch],y              ; get Next A
2003 7407
2004 7407 A4 F2                 ldy   Src1
2005 7409 D7 EE                 cmp   [SrcBase1],y             ; compare with next1
2006 740B
2007 740B 30 D4                 bmi   Less2
2008 740D D0 E9                 bne   Less1                    ; if Next1 < Next2, take from 1
2009 740F 80 BB                 bra   Equal
2010 7411
2011 7411                       ENDP 
2012 7411              ;                copy rgndefs/rgnop
2013 7411              ****************************************************************
2014 7411              *
2015 7411              * Procedure RgnOp;
2016 7411              *
2017 7411              *   Accepts two source regions in RgnHandleA and RgnHandleB and
2018 7411              *   assumes they have been dereferenced and locked down.  It
2019 7411              *   creates a buffer based on PtCount.  The horizontal offset
2020 7411              *   used in the event of and InsetRgn call is passed in register
2021 7411              *   X.  The operation to perform is passed in Op.
2022 7411              *
2023 7411              *   Computes the intersection, difference, union, or xor of
2024 7411              *   two regions or the horizontal inset of one region, and stores
2025 7411              *   the result as an unpacked array of sorted inversion points
2026 7411              *   in bufHandle.  Returns the number of points in PtCount.
2027 7411              *   BufHandle will be grown only if more space is needed.  RgnOp
2028 7411              *   returns an error if one is returned from the memory manager.
2029 7411              *
2030 7411              *    Sect = 0   A-B Diff = 2   Union = 4   Xor = 6   HInset = 8
2031 7411              *
2032 7411              ****************************************************************
2033 7411
2034 7411                       EXPORT iRgnOp 
2035 7411              iRgnOp   PROC 
2036 7411
2037 7411              * We generate some scratch space - an awful process but we have to get
2038 7411              * the memory we need from somewhere - might as well grab it all at once.
2039 7411              * Here follows the usage of that memory.
2040 7411
2041 7411              FakeA    equ   0                        ; offset to FakeA region
2042 7411              FakeB    equ   FakeA+18                 ; offset to FakeB region
2043 7411              Scan     equ   FakeB+18                 ; offset to start of scan buffers
2044 7411              ScratchSize equ   10280                 ; 10 K of space, maximum
2045 7411              Partition equ   2048                    ; size of one partition
2046 7411
2047 7411
2048 7411 86 B8                 stx   DH                       ; save horizontal offset
2049 7413 64 BC                 stz   BufHandle                ; zero handle to nil
2050 7415 64 BE                 stz   BufHandle+2
2051 7417              *
2052 7417              * NEW CODE
2053 7417              * 1/6/88
2054 7417              * This is the new region cache code.
2055 7417              * On the third zero page (only place left) at "RgnCache" there
2056 7417              * is a handle to 10Kbytes of memory for use as a temporary working area for
2057 7417              * rgnops. This cache is purgable so each time we call region op we check to see
2058 7417              * if the handle is empty. If the handle has been purged then we restore the
2059 7417              * handle, if is has not been purged then we reuse it.
2060 7417              * The initial call to allocate the cache memory is made in QDStartUp.
2061 7417              * The handle is locked while we are in this routine and unlocked on exit.
2062 7417              *
2063 7417 A2 F4 02     DerefAgain ldx   #RgnCache              ;deref and lock the handle
2064 741A 20 0D 5B              jsr   DeRefHandle
2065 741D C9 00 00              cmp   #0                       ;both will be zero if cache has been
2066 7420 D0 19                 bne   CacheEst                 ;purged
2067 7422 E0 00 00              cpx   #0
2068 7425 D0 14                 bne   CacheEst                 ;branch if cache is still allocated
2069 7427
2070 7427 A2 F4 02              ldx   #RgnCache
2071 742A B5 02                 lda   2,x                      ;put cache handle on stack
2072 742C 48                    pha   
2073 742D B5 00                 lda   0,x
2074 742F 48                    pha   
2075 7430 A2 02 0B 22           _RestoreHandle                 ;reallocates space for cache
2076 7437                                                      ;The handle must already be the right size
2077 7437 90 DE                 bcc   DerefAgain
2078 7439
2079 7439 38                    sec                            ;indicate error
2080 743A 6B                    rtl   
2081 743B
2082 743B              CacheEst                                ; 
2083 743B
2084 743B 85 E0        T1       sta   Scratch                  ; save pointer
2085 743D 86 E2                 stx   Scratch+2
2086 743F
2087 743F A5 C4                 lda   PtCount                  ; get size of BufHandle
2088 7441 A2 BC 00              ldx   #BufHandle               ; get offset
2089 7444 20 62 5B              jsr   GetNewHandle
2090 7447 90 03                 bcc   T2                       ; if an error, return it
2091 7449 82 7D 01              brl   MemError
2092 744C
2093 744C 85 C0        T2       sta   BufPtr
2094 744E 86 C2                 stx   BufPtr+2
2095 7450 A0 02 00              ldy   #2
2096 7453 A9 04 00              lda   #4
2097 7456 97 C0                 sta   [BufPtr],y               ; initialize buffer index
2098 7458
2099 7458              * Move RgnPtrA to FakeA and expand it to a 4 point packed region if rectangular
2100 7458
2101 7458 20 BE 71              jsr   ExpandA                  ; expand FakeA
2102 745B 20 1C 72              jsr   ExpandB                  ; expand FakeB
2103 745E
2104 745E              * Initialize assorted pointers
2105 745E
2106 745E 38                    sec                            ; prepare for subtract
2107 745F A5 C4                 lda   PtCount                  ; get size of BufHandle
2108 7461 E9 04 00              sbc   #4                       ; remove length and index bytes
2109 7464 29 F8 FF              and   #$FFF8                   ; truncate to an integral # of points
2110 7467 18                    clc                            ; prepare for add
2111 7468 69 04 00              adc   #4                       ; put length and index bytes back in
2112 746B 85 C8                 sta   ListMax                  ; biggest we can handle
2113 746D
2114 746D A0 04 00              ldy   #4                       ; offset to first buffer dest
2115 7470 84 C6                 sty   ListPtr                  ; save it
2116 7472
2117 7472 A0 24 00              ldy   #Scan                    ; offset to first scan buffer
2118 7475 A9 FF 3F              lda   #MaxInt                  ; get MaxInt
2119 7478 97 E0                 sta   [Scratch],y              ; initialize ScanA to empty
2120 747A 84 E4                 sty   ScanA                    ; save it in ScanA
2121 747C
2122 747C A0 24 08              ldy   #(Scan+Partition)        ; offset to second scan buffer
2123 747F 97 E0                 sta   [Scratch],y              ; initialize ScanB to empty
2124 7481 84 E6                 sty   ScanB                    ; save it in ScanB
2125 7483
2126 7483 A0 24 10              ldy   #(Scan+Partition*2)      ; offset to third scan buffer
2127 7486 97 E0                 sta   [Scratch],y              ; initialize ScanC to empty
2128 7488 84 E8                 sty   ScanC                    ; save it in ScanC
2129 748A
2130 748A A0 24 18              ldy   #(Scan+Partition*3)      ; offset to fourth scan buffer
2131 748D 84 EA                 sty   TempScan                 ; save it in TempScan
2132 748F
2133 748F A0 24 20              ldy   #(Scan+Partition*4)      ; offset to fifth scan buffer
2134 7492 84 EC                 sty   OutScan                  ; save it in OutScan
2135 7494
2136 7494 A5 E0 85 EE           Movelong Scratch,SrcBase1      ; initialize SrcBase1
2137 749C
2138 749C A4 D4                 ldy   PtrA                     ; get PtrA
2139 749E B7 D0                 lda   [PtrBaseA],y             ; NextA := first vert in A
2140 74A0 85 CA                 sta   NextA                    ; save it
2141 74A2 C8 C8                 IncYWd                         ; bump y to next word
2142 74A4 84 D4                 sty   PtrA                     ; save it
2143 74A6
2144 74A6 A4 DA                 ldy   PtrB                     ; get PtrB
2145 74A8 B7 D6                 lda   [PtrBaseB],y             ; NextB := first vert in B
2146 74AA 85 CC                 sta   NextB                    ; save it
2147 74AC C8 C8                 IncYWd                         ; bump y to next word
2148 74AE 84 DA                 sty   PtrB                     ; save it
2149 74B0
2150 74B0 A5 BA                 lda   Op                       ; get Op
2151 74B2 C9 08 00              cmp   #8                       ; is it Inset
2152 74B5 D0 05                 bne   NxtVert                  ; no, continue
2153 74B7 A9 FF 3F              lda   #MaxInt                  ; get maxint
2154 74BA 85 CC                 sta   NextB                    ; save it in NextB
2155 74BC
2156 74BC A5 CA        NxtVert  lda   NextA                    ; get NextA
2157 74BE C5 CC                 cmp   NextB                    ; set flags on NextA - NextB
2158 74C0 F0 40                 beq   Both                     ; they're equal, bump both
2159 74C2 10 46                 bpl   UpdateB                  ; B, update RgnB only
2160 74C4 20 C9 74              jsr   UpdateA                  ; A, update RgnA only
2161 74C7 80 76                 bra   Calc
2162 74C9
2163 74C9 A5 CA        UpdateA  lda   NextA                    ; get NextA
2164 74CB 85 CE                 sta   Vert                     ; Vert := NextA
2165 74CD A5 D0 85 EE           Movelong PtrBaseA,SrcBase1     ; establish the source base pointer
2166 74D5 A4 D4                 ldy   PtrA                     ; get PtrA
2167 74D7 84 F2                 sty   Src1                     ; Src1 := PtrA
2168 74D9
2169 74D9 A4 E4                 ldy   ScanA                    ; get ScanA
2170 74DB 84 F4                 sty   Src2                     ; Src2 := ScanA
2171 74DD
2172 74DD A4 EA                 ldy   TempScan                 ; get TempScan
2173 74DF 84 F6                 sty   Dst                      ; Dst := TempScan
2174 74E1
2175 74E1 20 BE 73              jsr   XorScan                  ; XorScan(PtrA,ScanA,TempScan)
2176 74E4 A5 E0 85 EE           Movelong Scratch,SrcBase1      ; put it back where it belongs
2177 74EC
2178 74EC A4 F2                 ldy   Src1                     ; get Src1; y is PtrA, bu
2179 74EE B7 D0                 lda   [PtrBaseA],y             ; get next vert
2180 74F0 85 CA                 sta   NextA                    ; NextA := next Vert
2181 74F2 C8 C8                 IncYWd                         ; bump y
2182 74F4 84 D4                 sty   PtrA                     ; save it
2183 74F6 A6 EA                 ldx   TempScan                 ; get TempScan
2184 74F8 A5 E4                 lda   ScanA                    ; get ScanA
2185 74FA 86 E4                 stx   ScanA                    ; swap them
2186 74FC 85 EA                 sta   TempScan                 ; like so
2187 74FE 60                    rts                            ; return to local caller
2188 74FF
2189 74FF              * When we get to Both, the A register contains the next vertical.  If it
2190 74FF              * is Maxint, we're done.
2191 74FF
2192 74FF 4C D3 75     XDone    jmp   Done                     ; relay branch
2193 7502
2194 7502 C9 FF 3F     Both     cmp   #MaxInt                  ; is it Maxint?
2195 7505 F0 F8                 beq   XDone                    ; if so, all done
2196 7507 20 C9 74              jsr   UpdateA                  ; update RgnA
2197 750A A5 CC        UpdateB  lda   NextB                    ; vert := NextB
2198 750C 85 CE                 sta   Vert                     ; do it
2199 750E
2200 750E A5 D6 85 EE           Movelong PtrBaseB,SrcBase1     ; establish the source base pointer
2201 7516 A5 DA                 lda   PtrB                     ; get PtrB
2202 7518 85 F2                 sta   Src1                     ; Src1 := PtrB
2203 751A
2204 751A A5 E6                 lda   ScanB                    ; get ScanB
2205 751C 85 F4                 sta   Src2                     ; Src2 := ScanB
2206 751E
2207 751E A5 EA                 lda   TempScan                 ; get TempScan
2208 7520 85 F6                 sta   Dst                      ; Dst := TempScan
2209 7522
2210 7522 20 BE 73              jsr   XorScan                  ; XorScan(PtrB,ScanB,TempScan)
2211 7525 A5 E0 85 EE           Movelong Scratch,SrcBase1      ; put it back where it belongs
2212 752D
2213 752D A4 F2                 ldy   Src1                     ; get Src1
2214 752F B7 D6                 lda   [PtrBaseB],y             ; get next vert
2215 7531 85 CC                 sta   NextB                    ; NextB := next vert
2216 7533 C8 C8                 IncYWd                         ; bump y
2217 7535 84 DA                 sty   PtrB                     ; PtrB := end of scan + 2
2218 7537 A6 EA                 ldx   TempScan                 ; get temp scan
2219 7539 A5 E6                 lda   ScanB                    ; get ScanB
2220 753B 86 E6                 stx   ScanB                    ; swap them
2221 753D 85 EA                 sta   TempScan                 ; like so
2222 753F
2223 753F              * Calculate sect, diff, union, xor, or inset into ScanC
2224 753F
2225 753F A5 E4        Calc     lda   ScanA                    ; get ScanA
2226 7541 85 F2                 sta   Src1                     ; Src1 := ScanA
2227 7543 A5 E6                 lda   ScanB                    ; get ScanB
2228 7545 85 F4                 sta   Src2                     ; Src2 := ScanB
2229 7547 A5 EA                 lda   TempScan                 ; get TempScan
2230 7549 85 F6                 sta   Dst                      ; Dst := TempScan
2231 754B A6 BA                 ldx   Op                       ; fetch Op (0,2,4,6,8)
2232 754D FC 52 75              jsr   (CaseTab,x)              ; execute OpScan
2233 7550 80 0A                 bra   Changes                  ; jump around casetab
2234 7552
2235 7552 83 72        CaseTab  DC W:SectScan                  ; address of SectScan
2236 7554 89 72                 DC W:DiffScan                  ; address of DiffScan
2237 7556 90 72                 DC W:UnionScan                 ; address of UnionScan
2238 7558 BE 73                 DC W:XorScan                   ; address of XorScan
2239 755A 3D 73                 DC W:InsetScan                 ; address of InsetScan
2240 755C
2241 755C A5 EA        Changes  lda   TempScan                 ; get TempScan
2242 755E 85 F2                 sta   Src1                     ; Src1 := TempScan
2243 7560 A5 E8                 lda   ScanC                    ; get ScanC
2244 7562 85 F4                 sta   Src2                     ; Src2 := ScanC
2245 7564 A4 EC                 ldy   OutScan                  ; get offset to OutScan
2246 7566 84 F6                 sty   Dst                      ; Dst := OutScan
2247 7568 20 BE 73              jsr   XorScan                  ; XorScan(TempScan,ScanC,OutScan)
2248 756B A6 EA                 ldx   TempScan                 ; get TempScan
2249 756D A5 E8                 lda   ScanC                    ; get ScanC
2250 756F 86 E8                 stx   ScanC                    ; swap them
2251 7571 85 EA                 sta   TempScan                 ; like so
2252 7573
2253 7573 A4 EC                 ldy   OutScan                  ; where the data was placed
2254 7575 84 F2                 sty   Src1                     ; index we'll use to fetch it
2255 7577 A4 C6                 ldy   ListPtr                  ; so the comparison will work
2256 7579 80 2A                 bra   OutTest                  ; go to loop start
2257 757B
2258 757B B7 E0        OutLoop  lda   [Scratch],y              ; get H coord from OutScan
2259 757D 85 2A                 sta   Temp                     ; save it
2260 757F C8 C8                 IncYWd                         ; bump y to next H offset
2261 7581 B7 E0                 lda   [Scratch],y              ; get next H coord from OutScan
2262 7583 85 2C                 sta   Temp+2                   ; save it too
2263 7585 C8 C8                 IncYWd                         ; bump y again
2264 7587 84 F2                 sty   Src1                     ; tuck it away
2265 7589
2266 7589 A4 C6                 ldy   ListPtr                  ; get output destination offset
2267 758B A5 CE                 lda   Vert                     ; get V back
2268 758D 97 C0                 sta   [BufPtr],y               ; save it
2269 758F C8 C8                 IncYWd                         ; bump y
2270 7591 A5 2A                 lda   Temp                     ; get H
2271 7593 97 C0                 sta   [BufPtr],y               ; save it
2272 7595 C8 C8                 IncYWd                         ; bump y
2273 7597 A5 CE                 lda   Vert                     ; get V value
2274 7599 97 C0                 sta   [BufPtr],y               ; save it
2275 759B C8 C8                 IncYWd                         ; bump y
2276 759D A5 2C                 lda   Temp+2                   ; get H
2277 759F 97 C0                 sta   [BufPtr],y               ; save it
2278 75A1 C8 C8                 IncYWd                         ; bump y
2279 75A3 84 C6                 sty   ListPtr                  ; save it
2280 75A5
2281 75A5 C4 C8        OutTest  cpy   ListMax                  ; set flags on ListPtr-ListMax
2282 75A7 90 14                 bcc   SizeOk                   ; if ListMax > ListPtr, continue
2283 75A9
2284 75A9              * The point buffer is full.  Grow it if Flags <> 0.
2285 75A9
2286 75A9 A5 C8                 lda   ListMax                  ; get current useful size
2287 75AB 18                    clc                            ; clear carry
2288 75AC 69 00 01              adc   #256                     ; bump by 256 bytes
2289 75AF 85 C8                 sta   ListMax                  ; the new value, already trimmed
2290 75B1 A2 BC 00              ldx   #BufHandle               ; get offset
2291 75B4 20 3B 5B              jsr   ResizeHandle             ; resize it, relock it
2292 75B7 B0 10                 bcs   MemError
2293 75B9 85 C0                 sta   BufPtr                   ; save new pointer
2294 75BB 86 C2                 stx   BufPtr+2
2295 75BD A4 F2        SizeOk   ldy   Src1                     ; get offset to next value from OutScan
2296 75BF B7 E0                 lda   [Scratch],y              ; get the next H coord
2297 75C1 C9 FF 3F              cmp   #MaxInt                  ; is it MaxInt?
2298 75C4 D0 B5                 bne   OutLoop                  ; no, go for more
2299 75C6 4C BC 74              jmp   NxtVert                  ; loop for next vert
2300 75C9
2301 75C9 48           MemError pha                            ; save error
2302 75CA A2 F4 02              ldx   #RgnCache
2303 75CD 20 28 5B              jsr   UnlockHandle
2304 75D0 68                    pla                            ; get error back
2305 75D1 38                    sec                            ; ensure error flag is set
2306 75D2 6B                    rtl   
2307 75D3
2308 75D3 A0 02 00     Done     ldy   #2                       ; offset to ListPtr index
2309 75D6 A5 C6                 lda   ListPtr                  ; get size
2310 75D8 97 C0                 sta   [BufPtr],y               ; save size
2311 75DA 4A                    lsr   a                        ; divide by 2
2312 75DB 4A                    lsr   a                        ; divided by 4
2313 75DC 3A                    dec   a                        ; minus 1 to generate # of points
2314 75DD 85 C4                 sta   PtCount                  ; update it
2315 75DF A2 F4 02     GetRidOfS ldx   #RgnCache
2316 75E2 20 28 5B              jsr   UnlockHandle
2317 75E5 18                    clc   
2318 75E6 6B                    rtl                            ; get out of here
2319 75E7
2320 75E7                       ENDP 
2321 75E7              ;                copy rgndefs/sectrgn
2322 75E7              ****************************************************************
2323 75E7              *
2324 75E7              * Procedure RgnAEmpty
2325 75E7              *
2326 75E7              *   Local procedure which checks RgnA (assumed dereferenced in
2327 75E7              *   RgnPtrA) to see if it is empty.  It checks both the vertical
2328 75E7              *   and the horizontal for emptiness, and leaves the carry set
2329 75E7              *   if they are, and clear if it's not empty.
2330 75E7              *
2331 75E7              ****************************************************************
2332 75E7                       EXPORT RgnAEmpty 
2333 75E7              RgnAEmpty PROC 
2334 75E7
2335 75E7 A0 04 00              ldy   #BBoxLeft                ; offset to left
2336 75EA B7 54                 lda   [RgnPtrA],y              ; get left
2337 75EC A0 08 00              ldy   #BBoxRight               ; offset to right
2338 75EF D7 54                 cmp   [RgnPtrA],y              ; set flags on left-right
2339 75F1 10 0A                 bpl   Done                     ; if left >= right, copy
2340 75F3 A0 02 00              ldy   #BBoxTop                 ; offset to top
2341 75F6 B7 54                 lda   [RgnPtrA],y              ; get top
2342 75F8 A0 06 00              ldy   #BBoxBottom              ; offset to bottom
2343 75FB D7 54                 cmp   [RgnPtrA],y              ; set flags on top-bottom
2344 75FD 60           Done     rts                            ; carry is set correctly, leave
2345 75FE
2346 75FE                       ENDP 
2347 75FE
2348 75FE              ****************************************************************
2349 75FE              *
2350 75FE              * Procedure RgnBEmpty
2351 75FE              *
2352 75FE              *   Local procedure which checks RgnB (assumed dereferenced in
2353 75FE              *   RgnPtrB) to see if it is empty.  It checks both the vertical
2354 75FE              *   and the horizontal for emptiness, and leaves the carry set
2355 75FE              *   if they are, and clear if it's not empty.
2356 75FE              *
2357 75FE              ****************************************************************
2358 75FE                       EXPORT RgnBEmpty 
2359 75FE              RgnBEmpty PROC 
2360 75FE
2361 75FE A0 04 00              ldy   #BBoxLeft                ; offset to left
2362 7601 B7 64                 lda   [RgnPtrB],y              ; get left
2363 7603 A0 08 00              ldy   #BBoxRight               ; offset to right
2364 7606 D7 64                 cmp   [RgnPtrB],y              ; set flags on left-right
2365 7608 10 0A                 bpl   Done                     ; if left >= right, copy
2366 760A A0 02 00              ldy   #BBoxTop                 ; offset to top
2367 760D B7 64                 lda   [RgnPtrB],y              ; get top
2368 760F A0 06 00              ldy   #BBoxBottom              ; offset to bottom
2369 7612 D7 64                 cmp   [RgnPtrB],y              ; set flags on top-bottom
2370 7614 60           Done     rts                            ; carry is set correctly, leave
2371 7615
2372 7615                       ENDP 
2373 7615
2374 7615
2375 7615              ****************************************************************
2376 7615              *
2377 7615              * Procedure RgnSector
2378 7615              *
2379 7615              *   Takes the regions in RgnPtrA and RgnPtrB and intersects
2380 7615              *   their bounding boxes, leaving the resulting rectangle in
2381 7615              *   RgnY1, RgnX1, RgnY2, and RgnX2 on zero page.  Called below
2382 7615              *   and by RectInRgn.
2383 7615              *
2384 7615              ****************************************************************
2385 7615                       EXPORT RgnSector 
2386 7615              RgnSector PROC 
2387 7615
2388 7615 A0 02 00              ldy   #BBoxTop                 ; offset to top
2389 7618 B7 54                 lda   [RgnPtrA],y              ; get first top
2390 761A D7 64                 cmp   [RgnPtrB],y              ; compare to second
2391 761C 10 02                 bpl   STop                     ; if A > B, use A
2392 761E B7 64                 lda   [RgnPtrB],y              ; get the other one
2393 7620 85 AE        STop     sta   RgnY1                    ; save Top
2394 7622 A0 06 00              ldy   #BBoxBottom              ; offset to bottom
2395 7625 B7 64                 lda   [RgnPtrB],y              ; get second bottom
2396 7627 D7 54                 cmp   [RgnPtrA],y              ; compare to first
2397 7629 30 02                 bmi   SBottom                  ; if B < A, use B
2398 762B B7 54                 lda   [RgnPtrA],y              ; get other one
2399 762D 85 B2        SBottom  sta   RgnY2                    ; save bottom
2400 762F A0 08 00              ldy   #BBoxRight               ; offset to right
2401 7632 B7 64                 lda   [RgnPtrB],y              ; get second right
2402 7634 D7 54                 cmp   [RgnPtrA],y              ; compare to first
2403 7636 30 02                 bmi   SRight                   ; if B < A, use B
2404 7638 B7 54                 lda   [RgnPtrA],y              ; get the other one
2405 763A 85 B4        SRight   sta   RgnX2                    ; save right
2406 763C A0 04 00              ldy   #BBoxLeft                ; offset to left
2407 763F B7 54                 lda   [RgnPtrA],y              ; get first left
2408 7641 D7 64                 cmp   [RgnPtrB],y              ; compare to second
2409 7643 10 02                 bpl   SLeft                    ; if A > B, use A
2410 7645 B7 64                 lda   [RgnPtrB],y              ; get the other one
2411 7647 85 B0        SLeft    sta   RgnX1                    ; save left
2412 7649 60                    rts   
2413 764A
2414 764A                       ENDP 
2415 764A
2416 764A              ****************************************************************
2417 764A              *
2418 764A              * Procedure SectRgn(
2419 764A              *   srcRgnA,srcRgnB,dstRgn:RgnHandle
2420 764A              *   )
2421 764A              *
2422 764A              *   Calculate the intersection of two regions.
2423 764A              *
2424 764A              ****************************************************************
2425 764A                       EXPORT SectRgn 
2426 764A              SectRgn  PROC 
2427 764A
2428 764A 20 AA 0F              jsr   QDStart
2429 764D
2430 764D A9 00 00              lda   #0                       ; op := Sect
2431 7650 4C 6E 76              jmp   DoRgnOp                  ; it does all the work
2432 7653
2433 7653                       ENDP 
2434 7653
2435 7653              ****************************************************************
2436 7653              *
2437 7653              * Procedure UnionRgn(
2438 7653              *   srcRgnA,srcRgnB,dstRgn:RgnHandle
2439 7653              *   )
2440 7653              *
2441 7653              *   Calculate the union of two regions.
2442 7653              *
2443 7653              ****************************************************************
2444 7653                       EXPORT UnionRgn 
2445 7653              UnionRgn PROC 
2446 7653
2447 7653 20 AA 0F              jsr   QDStart
2448 7656
2449 7656 A9 04 00              lda   #4                       ; op := Union
2450 7659 4C 6E 76              jmp   DoRgnOp                  ; it does all the work
2451 765C
2452 765C                       ENDP 
2453 765C
2454 765C              ****************************************************************
2455 765C              *
2456 765C              * Procedure DiffRgn(
2457 765C              *   srcRgnA,srcRgnB,dstRgn:RgnHandle
2458 765C              *   )
2459 765C              *
2460 765C              *   Calculate the difference A-B of two regions.
2461 765C              *
2462 765C              ****************************************************************
2463 765C                       EXPORT DiffRgn 
2464 765C              DiffRgn  PROC 
2465 765C
2466 765C 20 AA 0F              jsr   QDStart
2467 765F
2468 765F A9 02 00              lda   #2                       ; op := Diff
2469 7662 4C 6E 76              jmp   DoRgnOp                  ; it does all the work
2470 7665
2471 7665                       ENDP 
2472 7665
2473 7665              ****************************************************************
2474 7665              *
2475 7665              * Procedure XorRgn(
2476 7665              *   srcRgnA,srcRgnB,dstRgn:RgnHandle
2477 7665              *   )
2478 7665              *
2479 7665              *   Calculate the exclusive or of two regions.
2480 7665              *
2481 7665              ****************************************************************
2482 7665                       EXPORT XorRgn 
2483 7665              XorRgn   PROC 
2484 7665
2485 7665 20 AA 0F              jsr   QDStart
2486 7668
2487 7668 A9 06 00              lda   #6                       ; op := Xor
2488 766B 4C 6E 76              jmp   DoRgnOp                  ; it does all the work
2489 766E
2490 766E                       ENDP 
2491 766E
2492 766E              ****************************************************************
2493 766E              *
2494 766E              * Procedure DoRgnOp;
2495 766E              *
2496 766E              *   Computes the Intersection, Difference, Union, or Xor
2497 766E              *   of two regions.  Enter with Op in A.
2498 766E              *
2499 766E              *    Sect = 0       A-B Diff = 2      Union = 4      Xor = 6
2500 766E              *
2501 766E              ****************************************************************
2502 766E                       EXPORT DoRgnOp 
2503 766E              DoRgnOp  PROC 
2504 766E              *              using E0Vectors
2505 766E
2506 766E              OrigDirect equ   1
2507 766E              RTL1     equ   OrigDirect+2
2508 766E              RTL2     equ   RTL1+3
2509 766E              DstRgn   equ   RTL2+3
2510 766E              SrcRgnB  equ   DstRgn+4
2511 766E              SrcRgnA  equ   SrcRgnB+4
2512 766E
2513 766E 85 BA                 sta   Op                       ; save the operation
2514 7670 48                    pha                            ; room for result
2515 7671 A3 15                 lda   SrcRgnA+4,s              ; get high word
2516 7673 48                    pha                            ; push it
2517 7674 A3 15                 lda   SrcRgnA+4,s              ; get low word
2518 7676 48                    pha                            ; push it
2519 7677 A3 15                 lda   SrcRgnA+4,s              ; get high word
2520 7679 48                    pha                            ; push it
2521 767A A3 15                 lda   SrcRgnA+4,s              ; get low word
2522 767C 48                    pha                            ; push it
2523 767D A2 04 77 22           _EqualRgn                      ; are they equal?
2524 7684 68                    pla                            ; get boolean result
2525 7685 F0 3F                 beq   NotSame                  ; if 0 (false), we have more work
2526 7687 A5 BA                 lda   Op                       ; get op
2527 7689 29 02 00              and   #2                       ; and it with 2 (Diff and Xor bit)
2528 768C D0 1B                 bne   Zero                     ; zero it if Sect or Union
2529 768E
2530 768E A3 13        Copy     lda   SrcRgnA+2,s              ; get high word
2531 7690 48                    pha                            ; push it
2532 7691 A3 13                 lda   SrcRgnA+2,s              ; get low word
2533 7693 48                    pha                            ; push it
2534 7694 A3 0F                 lda   DstRgn+6,s               ; get high word
2535 7696 48                    pha                            ; push it
2536 7697 A3 0F                 lda   DstRgn+6,s               ; get low word
2537 7699 48                    pha                            ; push it
2538 769A A2 04 69 22           _CopyRgn                       ; copy it
2539 76A1 B0 1B                 bcs   T1
2540 76A3 20 D2 77              jsr   UnlockAB
2541 76A6 4C 71 FC              jmp   BusyEC12                 ; we can leave now
2542 76A9
2543 76A9 A3 0B        Zero     lda   DstRgn+2,s               ; get high word
2544 76AB 48                    pha                            ; push it
2545 76AC A3 0B                 lda   DstRgn+2,s               ; get low word
2546 76AE 48                    pha                            ; push it
2547 76AF A2 04 6A 22           _SetEmptyRgn                   ; zero the destination
2548 76B6 B0 06                 bcs   T1
2549 76B8 20 D2 77              jsr   UnlockAB
2550 76BB 4C 71 FC              jmp   BusyEC12
2551 76BE
2552 76BE 48           T1       pha                            ; save error code
2553 76BF 20 D2 77              jsr   UnlockAB
2554 76C2 FA                    plx                            ; restore error code
2555 76C3 4C 74 FC              jmp   BusyErr12
2556 76C6
2557 76C6              * load the handles from the stack onto zero page and dereference them
2558 76C6
2559 76C6 A3 11        NotSame  lda   SrcRgnA,s                ; get low word of SrcRgnA
2560 76C8 85 50                 sta   RgnHandleA               ; save it
2561 76CA A3 13                 lda   SrcRgnA+2,s              ; get high word of SrcRgnA
2562 76CC 85 52                 sta   RgnHandleA+2             ; save it
2563 76CE 20 7D 5A              jsr   DerefA
2564 76D1
2565 76D1 A3 0D                 lda   SrcRgnB,s                ; get low word of SrcRgnB
2566 76D3 85 60                 sta   RgnHandleB               ; save it
2567 76D5 A3 0F                 lda   SrcRgnB+2,s              ; get high word of SrcRgnB
2568 76D7 85 62                 sta   RgnHandleB+2             ; save it
2569 76D9 20 9E 5A              jsr   DerefB
2570 76DC
2571 76DC              * If Op = Diff and RgnB is empty, copy RgnA into DstRgn
2572 76DC
2573 76DC A9 02 00              lda   #2                       ; get Diff opcode
2574 76DF C5 BA                 cmp   Op                       ; is it Diff?
2575 76E1 90 53                 bcc   UniXor                   ; if Op > Diff then Union or Xor
2576 76E3 D0 05                 bne   BBoxes                   ; if Op <> Diff, it's Sect
2577 76E5
2578 76E5              * Op = Diff, so check RgnB for empty
2579 76E5
2580 76E5 20 FE 75              jsr   RgnBEmpty                ; is RgnB empty
2581 76E8 10 A4                 bpl   Copy                     ; if it's empty, CopyRgnA
2582 76EA
2583 76EA              * If Op = Sect or Diff, then intersect the bounding boxes.
2584 76EA
2585 76EA 20 15 76     BBoxes   jsr   RgnSector                ; RgnY1..RgnX2 := RgnA * RgnB
2586 76ED
2587 76ED A5 B0                 lda   RgnX1
2588 76EF C5 B4                 cmp   RgnX2                    ; compare to X2
2589 76F1 10 06                 bpl   Empty                    ; if X1=X2, it's empty
2590 76F3 A5 AE                 lda   RgnY1                    ; get top
2591 76F5 C5 B2                 cmp   RgnY2                    ; if Y1 >= Y2, it's empty
2592 76F7 30 07                 bmi   NotEmpty                 ; so do it
2593 76F9
2594 76F9              * The bounding boxes don't intersect.  If Op = Sect, then return empty.
2595 76F9              * If Op = Diff, then copy RgnA into DstRgn
2596 76F9
2597 76F9 A5 BA        Empty    lda   Op                       ; get op
2598 76FB F0 AC                 beq   Zero                     ; if Sect, return empty
2599 76FD 4C 8E 76              jmp   Copy                     ; no, copy SrcA into DstRgn
2600 7700
2601 7700              * If Op = Sect, then check for both inputs rectangular
2602 7700
2603 7700 A5 BA        NotEmpty lda   Op                       ; is op = Sect
2604 7702 D0 62                 bne   NotEasy                  ; no, continue
2605 7704 A9 0A 00              lda   #10                      ; get rectangular region size
2606 7707 C7 54                 cmp   [RgnPtrA]                ; compare with RgnA length
2607 7709 D0 5B                 bne   NotEasy                  ; no, continue
2608 770B C7 64                 cmp   [RgnPtrB]                ; compare with RgnB length
2609 770D D0 57                 bne   NotEasy                  ; no, continue
2610 770F
2611 770F              * push dstrgn and address of temprect.  Could be bad news.
2612 770F
2613 770F A3 0B                 lda   DstRgn+2,s               ; get high word
2614 7711 48                    pha                            ; push it
2615 7712 A3 0B                 lda   DstRgn+2,s               ; get low word
2616 7714 48                    pha                            ; push it
2617 7715 18                    clc   
2618 7716 A9 00 00              lda   #0                       ; it's in bank 0
2619 7719 48                    pha                            ; push high word
2620 771A 7B                    tdc                            ; get direct register
2621 771B 69 AE 00              adc   #RgnY1                   ; add in offset
2622 771E 48                    pha                            ; push low word
2623 771F A2 04 6C 22           _RectRgn                       ; RectRgn(dstRgn,tempRect)
2624 7726 B0 06                 bcs   T2
2625 7728 20 D2 77              jsr   UnlockAB
2626 772B 4C 71 FC              jmp   BusyEC12
2627 772E
2628 772E 48           T2       pha                            ; save error
2629 772F 20 D2 77              jsr   UnlockAB
2630 7732 FA                    plx                            ; restore error
2631 7733 4C 74 FC              jmp   BusyErr12
2632 7736
2633 7736 20 FE 75     UniXor   jsr   RgnBEmpty                ; is RgnB empty?
2634 7739 30 03                 bmi   T3                       ; yes, copy RgnA
2635 773B 82 50 FF              brl   Copy
2636 773E 20 E7 75     T3       jsr   RgnAEmpty                ; is RgnA empty?
2637 7741 30 23                 bmi   NotEasy                  ; yes, copy RgnB
2638 7743 A3 0F                 lda   SrcRgnB+2,s              ; get high word
2639 7745 48                    pha                            ; push it
2640 7746 A3 0F                 lda   SrcRgnB+2,s              ; get low word
2641 7748 48                    pha                            ; push it
2642 7749 A3 0F                 lda   DstRgn+6,s               ; get high word
2643 774B 48                    pha                            ; push it
2644 774C A3 0F                 lda   DstRgn+6,s               ; get low word
2645 774E 48                    pha                            ; push it
2646 774F A2 04 69 22           _CopyRgn                       ; copy it
2647 7756 B0 06                 bcs   T4
2648 7758 20 D2 77              jsr   UnlockAB
2649 775B 4C 71 FC              jmp   BusyEC12
2650 775E
2651 775E 48           T4       pha   
2652 775F 20 D2 77              jsr   UnlockAB
2653 7762 FA                    plx   
2654 7763 4C 74 FC              jmp   BusyErr12
2655 7766
2656 7766 18           NotEasy  clc                            ; clear carry for addition
2657 7767 A7 54                 lda   [RgnPtrA]                ; get RgnA length
2658 7769 67 64                 adc   [RgnPtrB]                ; add RgnB length
2659 776B 0A                    asl   a                        ; double (Quickdraw did ADD D4,D4)
2660 776C 85 C4                 sta   PtCount                  ; save it
2661 776E
2662 776E              * We've taken all the shortcuts we can.  Now we pass the buck to RgnOp to do
2663 776E              * the real work.  The source regions are still in RgnHandleA and RgnHandleB.
2664 776E              * PtCount contains the maximum size we should need.  Load X with 0 since we
2665 776E              * have no horizontal offset to worry about (just for cleanliness).
2666 776E
2667 776E A2 00 00              ldx   #0                       ; unnecessary unless code changes
2668 7771 22 98 1F E0           jsl   RgnOp                    ; do it
2669 7775 B0 2C                 bcs   RgnOpError               ; RgnOp propogates errors
2670 7777 A3 09                 lda   DstRgn,s
2671 7779 85 50                 sta   RgnHandleA
2672 777B A3 0B                 lda   DstRgn+2,s
2673 777D 85 52                 sta   RgnHandleA+2
2674 777F 20 7D 5A              jsr   DerefA
2675 7782 22 94 1F E0           jsl   PackRgn                  ; call it
2676 7786
2677 7786 A5 BE 48 A5           PushLong BufHandle             ; push handle
2678 778C A2 02 10 22           _DisposeHandle                 ; dispose of point buffer handle
2679 7793 B0 06                 bcs   T5
2680 7795 20 D2 77              jsr   UnlockAB
2681 7798 4C 71 FC              jmp   BusyEC12
2682 779B
2683 779B 48           T5       pha                            ; save error code
2684 779C 20 D2 77              jsr   UnlockAB
2685 779F FA                    plx                            ; get error code back
2686 77A0 4C 74 FC              jmp   BusyErr12
2687 77A3
2688 77A3 48           RgnOpError pha                          ; save error code
2689 77A4 A2 03 2C 22           _SysBeep 
2690 77AB A2 03 2C 22           _SysBeep 
2691 77B2
2692 77B2 A5 BC                 lda   BufHandle
2693 77B4 05 BE                 ora   BufHandle+2
2694 77B6 F0 13                 beq   DontDispose
2695 77B8 A2 BC 00              ldx   #BufHandle
2696 77BB 20 28 5B              jsr   UnlockHandle
2697 77BE A5 BE 48 A5           PushLong BufHandle 
2698 77C4 A2 02 10 22           _DisposeHandle 
2699 77CB 20 D2 77     DontDispose jsr   UnlockAB
2700 77CE FA                    plx                            ; get error code back
2701 77CF 4C 74 FC              jmp   BusyErr12
2702 77D2
2703 77D2 A2 50 00     UnlockAB ldx   #RgnHandleA
2704 77D5 20 28 5B              jsr   UnlockHandle
2705 77D8 A2 60 00              ldx   #RgnHandleB
2706 77DB 20 28 5B              jsr   UnlockHandle
2707 77DE 60                    rts   
2708 77DF
2709 77DF                       ENDP 
2710 77DF
2711 77DF              ;                copy rgndefs/insetrgn
2712 77DF              ****************************************************************
2713 77DF              *
2714 77DF              * Procedure InsetRgn
2715 77DF              *
2716 77DF              * Inputs: rgnHandle:RgnHandle
2717 77DF              *         dH:Integer
2718 77DF              *         dV:Integer
2719 77DF              * Description:
2720 77DF              *        Shrinks or expands a specified region. All points on the region
2721 77DF              *        boundary are moved inward a distance of dH horizontally and
2722 77DF              *        dV verticaly. If dh or dv are negative, the points are moved
2723 77DF              *        outward in that direction. Inset Rgn leaves the region centered on
2724 77DF              *        the same position but moves the outline. InsetRgn of a rect rgn works
2725 77DF              *        the same as insetRect.
2726 77DF              ****************************************************************
2727 77DF
2728 77DF
2729 77DF
2730 77DF
2731 77DF                       EXPORT InsetRgn 
2732 77DF              InsetRgn PROC 
2733 77DF              *              using E0Vectors
2734 77DF
2735 77DF              OrigDirect equ   1
2736 77DF              RTL1     equ   OrigDirect+2
2737 77DF              RTL2     equ   RTL1+3
2738 77DF              Dvs      equ   RTL2+3
2739 77DF              Dhs      equ   Dvs+2
2740 77DF              Rgn      equ   Dhs+2
2741 77DF
2742 77DF 20 AA 0F              jsr   QDStart
2743 77E2
2744 77E2              * Setup direct page references to the region handle and pointer.
2745 77E2
2746 77E2 A3 0D                 lda   Rgn,s
2747 77E4 85 50                 sta   RgnHandleA
2748 77E6 A3 0F                 lda   Rgn+2,s
2749 77E8 85 52                 sta   RgnHandleA+2
2750 77EA A2 50 00              ldx   #RgnHandleA              ; offset
2751 77ED 20 0D 5B              jsr   DerefHandle
2752 77F0 85 54                 sta   RgnPtrA                  ; save pointer
2753 77F2 86 56                 stx   RgnPtrA+2
2754 77F4
2755 77F4              * Is this region rectangular?
2756 77F4
2757 77F4 A7 54                 lda   [RgnPtrA]
2758 77F6 C9 0A 00              cmp   #10
2759 77F9 D0 44                 bne   NotRect
2760 77FB
2761 77FB              * This region is rectangular so we add the offset to the right and bottom
2762 77FB              * and subtract the offsets from the top and left.
2763 77FB
2764 77FB A3 0B                 lda   Dhs,s
2765 77FD 85 B8                 sta   Dh                       ; copy the parameters
2766 77FF A3 09                 lda   Dvs,s
2767 7801 85 B6                 sta   Dv
2768 7803
2769 7803 A0 02 00              ldy   #2                       ; I could call _InsetRect, but
2770 7806 B7 54                 lda   [RgnPtrA],y              ; that takes almost as much code
2771 7808 18                    clc                            ; to set up as just doing it, and
2772 7809 65 B6                 adc   Dv                       ; it will certainly be slower.
2773 780B 97 54                 sta   [RgnPtrA],y
2774 780D
2775 780D A0 04 00              ldy   #4
2776 7810 B7 54                 lda   [RgnPtrA],y
2777 7812 18                    clc   
2778 7813 65 B8                 adc   Dh
2779 7815 97 54                 sta   [RgnPtrA],y
2780 7817
2781 7817 A0 06 00              ldy   #6
2782 781A B7 54                 lda   [RgnPtrA],y
2783 781C 38                    sec   
2784 781D E5 B6                 sbc   Dv
2785 781F 97 54                 sta   [RgnPtrA],y
2786 7821
2787 7821 A0 08 00              ldy   #8
2788 7824 B7 54                 lda   [RgnPtrA],y
2789 7826 38                    sec   
2790 7827 E5 B8                 sbc   Dh
2791 7829 97 54                 sta   [RgnPtrA],y
2792 782B A2 50 00     Done     ldx   #RgnHandleA
2793 782E 20 28 5B              jsr   UnlockHandle
2794 7831 4C 45 FC              jmp   BusyEC8
2795 7834
2796 7834 48           ErrorReturn pha                         ; save error
2797 7835 A2 50 00              ldx   #RgnHandleA
2798 7838 20 28 5B              jsr   UnlockHandle
2799 783B FA                    plx                            ; restore error
2800 783C 4C 48 FC              jmp   BusyErr8
2801 783F
2802 783F              * RgnOp will do most of the work for us.  To call it, put the source in both
2803 783F              * RgnHandleA and RgnHandleB.  It allocates BufHandle.  Pass the horizontal
2804 783F              * offset in register X, and pass the operation (HInset=8) in Op.  Pass the
2805 783F              * expected size of BufHandle in PtCount.
2806 783F
2807 783F A3 0B        NotRect  lda   Dhs,s
2808 7841 AA                    tax   
2809 7842 20 4D 78              jsr   HInset
2810 7845 A3 09                 lda   Dvs,s
2811 7847 AA                    tax   
2812 7848 20 4D 78              jsr   HInset
2813 784B 80 DE                 bra   Done                     ; above
2814 784D
2815 784D              * End of the core of Inset
2816 784D
2817 784D
2818 784D
2819 784D A5 50 85 60  HInset   MoveLong RgnHandleA,RgnHandleB   ; in case PackRgn moved RgnA
2820 7855 A5 54 85 64           MoveLong RgnPtrA,RgnPtrB 
2821 785D A7 54                 lda   [RgnPtrA]                ; get current size
2822 785F 0A                    asl   a                        ; double it
2823 7860 85 C4                 sta   PtCount                  ; save suggested length
2824 7862 A9 08 00              lda   #8
2825 7865 85 BA                 sta   Op
2826 7867 22 98 1F E0           jsl   RgnOp                    ; creates BufHandle/BufPtr
2827 786B B0 74                 bcs   RgnOpError
2828 786D
2829 786D              * *BufPtr struct is
2830 786D              *         length: word
2831 786D              *         Index: word
2832 786D              *         pointlist: sorted array of inversion points.
2833 786D              *
2834 786D A0 02 00              ldy   #2
2835 7870 B7 C0                 lda   [BufPtr],y               ; get index
2836 7872 85 C4                 sta   PtCount                  ; temp variable
2837 7874
2838 7874 C9 05 00              cmp   #5                       ; did it drop to zero points?
2839 7877 10 2D                 bpl   GotPoints                ; no, so continue processing it
2840 7879
2841 7879              * We don't have any points left so
2842 7879              * Dispose of the buffer and set the region to empty
2843 7879              * !!!!!!! Shouldn't this leave a minimum size rectangle !!!!!!!!!
2844 7879
2845 7879 A2 BC 00              ldx   #BufHandle
2846 787C 20 28 5B              jsr   UnlockHandle
2847 787F A5 BE 48 A5           PushLong BufHandle 
2848 7885 A2 02 10 22           _DisposeHandle                 ; yes, so clean up
2849 788C B0 13                 bcs   ZeroError                ; handle error
2850 788E A5 52 48 A5           PushLong RgnHandleA            ; zero out the region
2851 7894 A2 04 6A 22           _SetEmptyRgn 
2852 789B B0 04                 bcs   ZeroError
2853 789D FA                    plx                            ; pull Hinset return
2854 789E 82 8A FF              brl   Done
2855 78A1
2856 78A1 AA           ZeroError tax   
2857 78A2 7A                    ply                            ; discard local return
2858 78A3 4C 48 FC              jmp   BusyErr8
2859 78A6
2860 78A6              * We still have a region larger than empty
2861 78A6
2862 78A6              * Swap the h and v positions in the buffer.
2863 78A6              * "I don't know why!"
2864 78A6              * Keep going until y = PtCount. Remember PtCount really contains [BufPtr],2
2865 78A6              *  the "index".
2866 78A6
2867 78A6 A0 04 00     GotPoints ldy   #4                      ; initialize our index
2868 78A9 B7 C0        SwapLp   lda   [BufPtr],y               ; get V
2869 78AB 48                    pha                            ; save the v
2870 78AC C8 C8                 IncYWd                         ; index to H
2871 78AE B7 C0                 lda   [BufPtr],y               ; get H
2872 78B0 AA                    tax                            ; put H into x
2873 78B1 68                    pla                            ; put V into a
2874 78B2 97 C0                 sta   [BufPtr],y               ; save V where H used to be
2875 78B4 8A                    txa                            ; get H back into a
2876 78B5 88 88                 DecYWd                         ; point back to where V used to be
2877 78B7 97 C0                 sta   [BufPtr],y               ; save H
2878 78B9 C8 C8 C8 C8           IncYPtr 
2879 78BD C4 C4                 cpy   PtCount                  ; are we done yet?
2880 78BF D0 E8                 bne   SwapLp
2881 78C1
2882 78C1              * y = PtCount. What we want to do here is PtCount = (PtCount/4) - 1
2883 78C1              * remember that PtCount = index.
2884 78C1
2885 78C1 98           ReSort   tya                            ; get index
2886 78C2 4A                    lsr   a                        ; divide by 4
2887 78C3 4A                    lsr   a
2888 78C4 3A                    dec   a                        ; decrement it
2889 78C5 85 C4                 sta   PtCount                  ; save it
2890 78C7
2891 78C7              * SortPoints takes the sorted array of points and does a quick sort on them
2892 78C7              * ??????????
2893 78C7 22 90 1F E0           jsl   SortPoints
2894 78CB 22 94 1F E0           jsl   PackRgn                  ; result is in RgnHandleA
2895 78CF B0 2F                 bcs   PackError
2896 78D1 A5 BE 48 A5           PushLong BufHandle 
2897 78D7 A2 02 10 22           _DisposeHandle                 ; get rid of it
2898 78DE B0 39                 bcs   DisposError
2899 78E0 60                    rts                            ; return to local caller
2900 78E1              * All done
2901 78E1
2902 78E1              * Handle Errors
2903 78E1
2904 78E1
2905 78E1 48           RgnOpError pha                          ; save error code
2906 78E2 A2 50 00              ldx   #RgnHandleA              ; unlock handle
2907 78E5 20 28 5B              jsr   UnlockHandle
2908 78E8 A5 BC                 lda   BufHandle                ; was it ever allocated?
2909 78EA 05 BE                 ora   BufHandle+2
2910 78EC F0 0D                 beq   DontDispose
2911 78EE A5 BE 48 A5           PushLong BufHandle             ; deallocate bufhandle
2912 78F4 A2 02 10 22           _DisposeHandle 
2913 78FB FA           DontDispose plx                         ; retreive error code
2914 78FC 7A                    ply                            ; pull local return
2915 78FD 4C 48 FC              jmp   BusyErr8
2916 7900
2917 7900 48           PackError pha                           ; save error code
2918 7901 A2 50 00              ldx   #RgnHandleA              ; unlock handle
2919 7904 20 28 5B              jsr   UnlockHandle
2920 7907 A5 BE 48 A5           PushLong BufHandle 
2921 790D A2 02 10 22           _DisposeHandle 
2922 7914 FA                    plx                            ; retrieve error code
2923 7915 7A                    ply                            ; discard local return
2924 7916 4C 48 FC              jmp   BusyErr8
2925 7919
2926 7919 AA           DisposError tax   
2927 791A 7A                    ply                            ; discard local return
2928 791B 4C 48 FC              jmp   BusyErr8
2929 791E
2930 791E                       ENDP 
2931 791E
2932 791E              ****************************************************************
2933 791E              *
2934 791E              * Procedure OffsetRgn
2935 791E              *
2936 791E              ****************************************************************
2937 791E                       EXPORT OffsetRgn 
2938 791E              OffsetRgn PROC 
2939 791E
2940 791E              OrigDirect equ   1
2941 791E              RTL1     equ   OrigDirect+2
2942 791E              RTL2     equ   RTL1+3
2943 791E              Dvs      equ   RTL2+3
2944 791E              Dhs      equ   Dvs+2
2945 791E              Rgn      equ   Dhs+2
2946 791E
2947 791E 20 AA 0F              jsr   QDStart
2948 7921
2949 7921 A3 0D                 lda   Rgn,s
2950 7923 85 50                 sta   RgnHandleA
2951 7925 A3 0F                 lda   Rgn+2,s
2952 7927 85 52                 sta   RgnHandleA+2
2953 7929 A3 0B                 lda   Dhs,s
2954 792B 85 B8                 sta   Dh
2955 792D A3 09                 lda   Dvs,s
2956 792F 85 B6                 sta   Dv
2957 7931 A2 50 00              ldx   #RgnHandleA              ; offset
2958 7934 20 0D 5B              jsr   DerefHandle
2959 7937 85 54                 sta   RgnPtrA                  ; save pointer
2960 7939 86 56                 stx   RgnPtrA+2
2961 793B
2962 793B              * Offset the bounding box
2963 793B
2964 793B A0 02 00              ldy   #2                       ; offset the top
2965 793E B7 54                 lda   [RgnPtrA],y
2966 7940 18                    clc   
2967 7941 65 B6                 adc   Dv
2968 7943 97 54                 sta   [RgnPtrA],y
2969 7945
2970 7945 A0 04 00              ldy   #4                       ; offset the left
2971 7948 B7 54                 lda   [RgnPtrA],y
2972 794A 18                    clc   
2973 794B 65 B8                 adc   Dh
2974 794D 97 54                 sta   [RgnPtrA],y
2975 794F
2976 794F A0 06 00              ldy   #6                       ; offset the bottom
2977 7952 B7 54                 lda   [RgnPtrA],y
2978 7954 18                    clc   
2979 7955 65 B6                 adc   Dv
2980 7957 97 54                 sta   [RgnPtrA],y
2981 7959
2982 7959 A0 08 00              ldy   #8                       ; offset the right
2983 795C B7 54                 lda   [RgnPtrA],y
2984 795E 18                    clc   
2985 795F 65 B8                 adc   Dh
2986 7961 97 54                 sta   [RgnPtrA],y
2987 7963
2988 7963 A9 0A 00              lda   #10                      ; if rectangular, we're done
2989 7966 C7 54                 cmp   [RgnPtrA]
2990 7968 F0 2C                 beq   Done
2991 796A A8                    tay   
2992 796B B7 54                 lda   [RgnPtrA],y
2993 796D 18           NxtVert  clc                            ; offset the vertical
2994 796E 65 B6                 adc   Dv
2995 7970 97 54                 sta   [RgnPtrA],y
2996 7972 C8 C8                 IncYWd 
2997 7974 B7 54                 lda   [RgnPtrA],y
2998 7976 18           NxtHor   clc                            ; offset 1st of horizontal pair
2999 7977 65 B8                 adc   Dh
3000 7979 97 54                 sta   [RgnPtrA],y
3001 797B C8 C8                 IncYWd 
3002 797D
3003 797D B7 54                 lda   [RgnPtrA],y              ; offset 2nd of horizontal pair
3004 797F 18                    clc   
3005 7980 65 B8                 adc   Dh
3006 7982 97 54                 sta   [RgnPtrA],y
3007 7984 C8 C8                 IncYWd 
3008 7986
3009 7986 B7 54                 lda   [RgnPtrA],y              ; check for end of scan line
3010 7988 C9 FF 3F              cmp   #MaxInt
3011 798B D0 E9                 bne   NxtHor
3012 798D C8 C8                 IncYWd 
3013 798F B7 54                 lda   [RgnPtrA],y
3014 7991 C9 FF 3F              cmp   #MaxInt                  ; check for end of region
3015 7994 D0 D7                 bne   NxtVert
3016 7996
3017 7996 A2 50 00     Done     ldx   #RgnHandleA
3018 7999 20 28 5B              jsr   UnlockHandle
3019 799C 4C 45 FC              jmp   BusyEC8
3020 799F
3021 799F                       ENDP 
3022 799F              ;                copy rgndefs/maprgn
3023 799F              ****************************************************************
3024 799F              *
3025 799F              * MapRgn
3026 799F              *
3027 799F              * Change History
3028 799F              * 7/23/87      GCP     MapRgn and PutRgn don't agree where the
3029 799F              *                      the input to putrgn should be so it is
3030 799F              *                      put in both locations.
3031 799F              *
3032 799F              ****************************************************************
3033 799F                       EXPORT MapRgn 
3034 799F              MapRgn   PROC 
3035 799F              *              using E0Vectors
3036 799F
3037 799F              OrigDirect equ   1
3038 799F              RTL1     equ   OrigDirect+2
3039 799F              RTL2     equ   RTL1+3
3040 799F              ToRectPtr equ   RTL2+3
3041 799F              FromRectPtr equ   ToRectPtr+4
3042 799F              Rgn      equ   FromRectPtr+4
3043 799F
3044 799F 20 AA 0F              jsr   QDStart
3045 79A2
3046 79A2 20 AA 7A              jsr   RetrieveRects
3047 79A5
3048 79A5              ;----------------------------------------------------------
3049 79A5              ;
3050 79A5              ; Are the rects different?  If not, we done.
3051 79A5              ;
3052 79A5
3053 79A5 A2 06 00              ldx   #6                       ; 3
3054 79A8 B5 DA        RectLoop lda   FRect,x                  ; 2
3055 79AA D5 E2                 cmp   TRect,x                  ; 2
3056 79AC D0 06                 bne   NotSame                  ; 2
3057 79AE CA                    dex                            ; 1
3058 79AF CA                    dex                            ; 1
3059 79B0 10 F6                 bpl   RectLoop                 ; 2
3060 79B2 80 2E                 bra   JDone                    ; 2
3061 79B4              ;                                       ; 15
3062 79B4
3063 79B4 22 C8 1F E0  NotSame  jsl   SetScaleAndMap           ; set up the mapping values
3064 79B8 A3 11                 lda   Rgn,s
3065 79BA 85 50                 sta   RgnHandleA
3066 79BC 85 70                 sta   RgnHandleC
3067 79BE A3 13                 lda   Rgn+2,s
3068 79C0 85 52                 sta   RgnHandleA+2
3069 79C2 85 72                 sta   RgnHandleC+2
3070 79C4
3071 79C4 20 7D 5A              jsr   DerefA
3072 79C7
3073 79C7 A7 54                 lda   [RgnPtrA]                ; get current region size
3074 79C9 C9 0A 00              cmp   #10
3075 79CC D0 1A                 bne   NotRect
3076 79CE
3077 79CE              ;----------------------------------------------------------
3078 79CE              ;
3079 79CE              ; Its a rectangular region so we'll just map the bounding
3080 79CE              ; box.
3081 79CE              ;
3082 79CE A5 54                 lda   RgnPtrA                  ; LocalMapPoint uses RgnPtrB
3083 79D0 85 64                 sta   RgnPtrB
3084 79D2 A5 56                 lda   RgnPtrA+2
3085 79D4 85 66                 sta   RgnPtrB+2
3086 79D6
3087 79D6 A0 02 00              ldy   #2
3088 79D9 20 D5 7B              jsr   LocalMapPoint
3089 79DC A0 06 00              ldy   #6
3090 79DF 20 D5 7B              jsr   LocalMapPoint
3091 79E2
3092 79E2              JDone                                   ; 
3093 79E2 20 93 5A              jsr   UnlockA
3094 79E5
3095 79E5 4C 71 FC              jmp   BusyEC12
3096 79E8
3097 79E8 0A           NotRect  asl   a                        ; double it, as a guess for the size
3098 79E9 18                    clc   
3099 79EA 69 04 00              adc   #4                       ; for the info stuff
3100 79ED A2 BC 00              ldx   #BufHandle               ; offset
3101 79F0 20 62 5B              jsr   GetNewHandle             ; get one
3102 79F3 90 0B                 bcc   T1
3103 79F5 48                    pha                            ; save error code
3104 79F6 A2 50 00              ldx   #RgnHandleA
3105 79F9 20 28 5B              jsr   UnlockHandle
3106 79FC FA                    plx                            ; retrieve error code
3107 79FD 4C 74 FC              jmp   BusyErr12
3108 7A00
3109 7A00              * RgnPtrA already holds the region to be mapped, and now RgnPtrC points
3110 7A00              * to a new buffer, ready to be filled.  PutRgn uses these and expands the
3111 7A00              * region into a list of inversion points.  It updates PtCount for us.
3112 7A00
3113 7A00 85 C0        T1       sta   BufPtr                   ; save pointer
3114 7A02 86 C2                 stx   BufPtr+2
3115 7A04 A0 02 00              ldy   #2
3116 7A07 A9 04 00              lda   #4
3117 7A0A 97 C0                 sta   [BufPtr],y               ; initialize buffer
3118 7A0C 22 84 1F E0           jsl   PutRgn
3119 7A10 90 1E                 bcc   T2
3120 7A12 48                    pha                            ; save error code
3121 7A13 A2 BC 00              ldx   #BufHandle
3122 7A16 20 28 5B              jsr   UnlockHandle             ; unlock it
3123 7A19 A5 BE 48 A5           Pushlong BufHandle 
3124 7A1F A2 02 10 22           _DisposeHandle 
3125 7A26 A2 50 00              ldx   #RgnHandleA
3126 7A29 20 28 5B              jsr   UnlockHandle
3127 7A2C FA                    plx                            ; retrieve error code
3128 7A2D 4C 74 FC              jmp   BusyErr12
3129 7A30
3130 7A30 A0 02 00     T2       ldy   #2
3131 7A33 B7 C0                 lda   [BufPtr],y               ; get index
3132 7A35 85 EA                 sta   LastPt
3133 7A37 A0 04 00              ldy   #4                       ; our current index
3134 7A3A 84 EE                 sty   Counter                  ; this will be our loop control, too
3135 7A3C A4 EE        MapLoop  ldy   Counter                  ; get counter
3136 7A3E C4 EA                 cpy   LastPt                   ; are we done yet
3137 7A40 10 21                 bpl   DoneLoop
3138 7A42 84 EC                 sty   LastY
3139 7A44 B7 C0                 lda   [BufPtr],y               ; get point V
3140 7A46 85 F0                 sta   MapV                     ; save on zero page
3141 7A48 C8 C8                 IncYWd 
3142 7A4A B7 C0                 lda   [BufPtr],y               ; get point H
3143 7A4C 85 F2                 sta   MapH                     ; save on zero page
3144 7A4E C8 C8                 IncYWd 
3145 7A50 84 EE                 sty   Counter                  ; save y
3146 7A52 20 1A 7B              jsr   MapAndScale              ; map it
3147 7A55 A4 EC                 ldy   LastY                    ; get last value back
3148 7A57 A5 F0                 lda   MapV
3149 7A59 97 C0                 sta   [BufPtr],y               ; save V result
3150 7A5B C8 C8                 IncYWd 
3151 7A5D A5 F2                 lda   MapH
3152 7A5F 97 C0                 sta   [BufPtr],y               ; save H result
3153 7A61 80 D9                 bra   MapLoop
3154 7A63
3155 7A63              * When we've finished mapping everything, we have a buffer of inversion
3156 7A63              * points in BufHandle, and it looks a lot like a CloseRgn call.  We sort
3157 7A63              * and cull and pack to put the region back in shape.  PtCount is already
3158 7A63              * set,
3159 7A63
3160 7A63 A5 EA        DoneLoop lda   LastPt                   ; current index
3161 7A65 4A                    lsr   a                        ; divide by 4
3162 7A66 4A                    lsr   a
3163 7A67 3A                    dec   a                        ; subtract status info
3164 7A68 85 C4                 sta   PtCount                  ; save it for our friends
3165 7A6A 22 90 1F E0           jsl   SortPoints
3166 7A6E 22 8C 1F E0           jsl   CullPoints
3167 7A72 22 94 1F E0           jsl   PackRgn
3168 7A76
3169 7A76 A2 50 00              ldx   #RgnHandleA
3170 7A79 20 28 5B              jsr   UnlockHandle
3171 7A7C A5 BE 48 A5           PushLong BufHandle 
3172 7A82 A2 02 10 22           _DisposeHandle 
3173 7A89 B0 1B                 bcs   Errout
3174 7A8B
3175 7A8B 4C 71 FC     Done     jmp   BusyEC12
3176 7A8E
3177 7A8E 48           PackError pha                           ; save error code
3178 7A8F A2 50 00              ldx   #RgnHandleA
3179 7A92 20 28 5B              jsr   UnlockHandle
3180 7A95 A5 BE 48 A5           PushLong BufHandle 
3181 7A9B A2 02 10 22           _DisposeHandle 
3182 7AA2 FA                    plx   
3183 7AA3 4C 74 FC              jmp   BusyErr12
3184 7AA6
3185 7AA6 AA           ErrOut   tax   
3186 7AA7 4C 74 FC              jmp   BusyErr12
3187 7AAA
3188 7AAA                       ENDP 
3189 7AAA
3190 7AAA              ****************************************************************
3191 7AAA              *
3192 7AAA              * RetrieveRects
3193 7AAA              *
3194 7AAA              ****************************************************************
3195 7AAA                       EXPORT RetrieveRects 
3196 7AAA              RetrieveRects PROC 
3197 7AAA
3198 7AAA              * This local routine locates a FromRect and ToRect in the stack
3199 7AAA              * and pulls the pointers out onto zero page.
3200 7AAA
3201 7AAA              ReturnAddress equ   1
3202 7AAA              OrigDirect equ   ReturnAddress+2
3203 7AAA              RTL1     equ   OrigDirect+2
3204 7AAA              RTL2     equ   RTL1+3
3205 7AAA              ToRectPtr equ   RTL2+3
3206 7AAA              FromRectPtr equ   ToRectPtr+4
3207 7AAA
3208 7AAA A3 0F                 lda   FromRectPtr,s
3209 7AAC 85 2A                 sta   Temp
3210 7AAE A3 11                 lda   FromRectPtr+2,s
3211 7AB0 85 2C                 sta   Temp+2
3212 7AB2
3213 7AB2 A7 2A                 lda   [Temp]
3214 7AB4 85 DA                 sta   FRect
3215 7AB6 A0 02 00              ldy   #2
3216 7AB9 B7 2A                 lda   [Temp],y
3217 7ABB 85 DC                 sta   FRect+2
3218 7ABD A0 04 00              ldy   #4
3219 7AC0 B7 2A                 lda   [Temp],y
3220 7AC2 85 DE                 sta   FRect+4
3221 7AC4 A0 06 00              ldy   #6
3222 7AC7 B7 2A                 lda   [Temp],y
3223 7AC9 85 E0                 sta   FRect+6
3224 7ACB
3225 7ACB A3 0B                 lda   ToRectPtr,s
3226 7ACD 85 2A                 sta   Temp
3227 7ACF A3 0D                 lda   ToRectPtr+2,s
3228 7AD1 85 2C                 sta   Temp+2
3229 7AD3
3230 7AD3 A7 2A                 lda   [Temp]
3231 7AD5 85 E2                 sta   TRect
3232 7AD7 A0 02 00              ldy   #2
3233 7ADA B7 2A                 lda   [Temp],y
3234 7ADC 85 E4                 sta   TRect+2
3235 7ADE A0 04 00              ldy   #4
3236 7AE1 B7 2A                 lda   [Temp],y
3237 7AE3 85 E6                 sta   TRect+4
3238 7AE5 A0 06 00              ldy   #6
3239 7AE8 B7 2A                 lda   [Temp],y
3240 7AEA 85 E8                 sta   TRect+6
3241 7AEC
3242 7AEC 60                    rts   
3243 7AED
3244 7AED                       ENDP 
3245 7AED
3246 7AED              ****************************************************************
3247 7AED              *
3248 7AED              *              SetScaleAndMap
3249 7AED              *
3250 7AED              ****************************************************************
3251 7AED                       EXPORT iSetScaleAndMap 
3252 7AED              iSetScaleAndMap PROC 
3253 7AED
3254 7AED              * This local routine uses FRect (FromRect) and TRect (ToRect) on
3255 7AED              * zero page to set up the parameters for MapPt (so we don't have
3256 7AED              * to do them more than once for MapRgn, MapRect, and MapPoly.
3257 7AED
3258 7AED              Top      equ   0
3259 7AED              Left     equ   2
3260 7AED              Bottom   equ   4
3261 7AED              Right    equ   6
3262 7AED
3263 7AED 38                    sec   
3264 7AEE A5 DE                 lda   FRect+Bottom
3265 7AF0 E5 DA                 sbc   FRect+Top
3266 7AF2 85 FA                 sta   FHeight
3267 7AF4 4A                    lsr   a                        ; calculate rounding term
3268 7AF5 85 04                 sta   HeightRound
3269 7AF7
3270 7AF7 38                    sec   
3271 7AF8 A5 E0                 lda   FRect+Right
3272 7AFA E5 DC                 sbc   FRect+Left
3273 7AFC 85 FC                 sta   FWidth
3274 7AFE 4A                    lsr   a                        ; calculate rounding term
3275 7AFF 85 06                 sta   WidthRound
3276 7B01
3277 7B01 38                    sec   
3278 7B02 A5 E6                 lda   TRect+Bottom
3279 7B04 E5 E2                 sbc   TRect+Top
3280 7B06 85 00                 sta   THeight
3281 7B08 38                    sec   
3282 7B09 E5 FA                 sbc   FHeight
3283 7B0B 85 F6                 sta   DifHeight
3284 7B0D
3285 7B0D 38                    sec   
3286 7B0E A5 E8                 lda   TRect+Right
3287 7B10 E5 E4                 sbc   TRect+Left
3288 7B12 85 02                 sta   TWidth
3289 7B14 38                    sec   
3290 7B15 E5 FC                 sbc   FWidth
3291 7B17 85 F8                 sta   DifWidth
3292 7B19
3293 7B19 6B                    rtl   
3294 7B1A
3295 7B1A                       ENDP 
3296 7B1A
3297 7B1A              ****************************************************************
3298 7B1A              *
3299 7B1A              * MapAndScale
3300 7B1A              *
3301 7B1A              ****************************************************************
3302 7B1A                       EXPORT MapAndScale 
3303 7B1A              MapAndScale PROC 
3304 7B1A
3305 7B1A              Top      equ   0
3306 7B1A              Left     equ   2
3307 7B1A              Bottom   equ   4
3308 7B1A              Right    equ   6
3309 7B1A
3310 7B1A 64 F4                 stz   Sign
3311 7B1C 38                    sec   
3312 7B1D A5 F0                 lda   MapV
3313 7B1F E5 DA                 sbc   Frect+Top
3314 7B21 A6 F6                 ldx   DifHeight
3315 7B23 F0 4F                 beq   NoVScale
3316 7B25 AA                    tax                            ; just to reset flags
3317 7B26 10 06                 bpl   NonNeg
3318 7B28 49 FF FF              eor   #$FFFF                   ; negate it
3319 7B2B 1A                    inc   a
3320 7B2C E6 F4                 inc   Sign
3321 7B2E F4 00 00     NonNeg   pea   0                        ; space for divide result
3322 7B31 F4 00 00              pea   0
3323 7B34 F4 00 00              pea   0
3324 7B37 F4 00 00              pea   0
3325 7B3A F4 00 00              pea   0                        ; space for multiply result
3326 7B3D F4 00 00              pea   0
3327 7B40 48                    pha   
3328 7B41 A5 00 48              PushWord THeight 
3329 7B44 A2 0B 09 22           _Multiply 
3330 7B4B 18                    clc   
3331 7B4C A5 04                 lda   HeightRound
3332 7B4E 63 01                 adc   1,s
3333 7B50 83 01                 sta   1,s
3334 7B52 A9 00 00              lda   #0
3335 7B55 63 03                 adc   3,s
3336 7B57 83 03                 sta   3,s
3337 7B59 F4 00 00              pea   0                        ; pushlong FHeight
3338 7B5C A5 FA 48              PushWord FHeight 
3339 7B5F A2 0B 0D 22           _LongDivide                    ; whew!
3340 7B66 68                    pla                            ; this is the answer
3341 7B67 FA                    plx                            ; if this is <> 0, we're dead anyway
3342 7B68 FA                    plx   
3343 7B69 FA                    plx   
3344 7B6A A6 F4                 ldx   Sign
3345 7B6C F0 06                 beq   NoVScale
3346 7B6E 49 FF FF              eor   #$FFFF
3347 7B71 1A                    inc   a
3348 7B72 64 F4                 stz   Sign
3349 7B74 18           NoVScale clc   
3350 7B75 65 E2                 adc   TRect+Top
3351 7B77 85 F0                 sta   MapV
3352 7B79
3353 7B79 38                    sec   
3354 7B7A A5 F2                 lda   MapH
3355 7B7C E5 DC                 sbc   FRect+Left
3356 7B7E A6 F8                 ldx   DifWidth
3357 7B80 F0 4D                 beq   NoHScale
3358 7B82 AA                    tax                            ; just to reset flags
3359 7B83 10 06                 bpl   NonNeg2
3360 7B85 49 FF FF              eor   #$FFFF                   ; negate it
3361 7B88 1A                    inc   a
3362 7B89 E6 F4                 inc   Sign
3363 7B8B F4 00 00     NonNeg2  pea   0                        ; space for divide result
3364 7B8E F4 00 00              pea   0
3365 7B91 F4 00 00              pea   0
3366 7B94 F4 00 00              pea   0
3367 7B97 F4 00 00              pea   0                        ; space for multiply result
3368 7B9A F4 00 00              pea   0
3369 7B9D 48                    pha   
3370 7B9E A5 02 48              PushWord TWidth 
3371 7BA1 A2 0B 09 22           _Multiply                      ; 32 bit result top of stack (TOS)
3372 7BA8
3373 7BA8 18                    clc   
3374 7BA9 A5 06                 lda   WidthRound
3375 7BAB 63 01                 adc   1,s
3376 7BAD 83 01                 sta   1,s
3377 7BAF A9 00 00              lda   #0
3378 7BB2 63 03                 adc   3,s
3379 7BB4 83 03                 sta   3,s                      ; we added the rounding to TOS
3380 7BB6
3381 7BB6 F4 00 00              pea   0                        ; pushlong FWidth
3382 7BB9 A5 FC 48              PushWord FWidth 
3383 7BBC A2 0B 0D 22           _LongDivide                    ; whew!
3384 7BC3 68                    pla                            ; this is the answer
3385 7BC4 FA                    plx                            ; if this is <> 0, we're dead anyway
3386 7BC5 FA                    plx                            ; discard remainder
3387 7BC6 FA                    plx   
3388 7BC7 A6 F4                 ldx   Sign
3389 7BC9 F0 04                 beq   NoHScale
3390 7BCB 49 FF FF              eor   #$FFFF
3391 7BCE 1A                    inc   a
3392 7BCF 18           NoHScale clc   
3393 7BD0 65 E4                 adc   TRect+Left
3394 7BD2 85 F2                 sta   MapH
3395 7BD4
3396 7BD4 60                    rts   
3397 7BD5
3398 7BD5                       ENDP 
3399 7BD5
3400 7BD5              ****************************************************************
3401 7BD5              *
3402 7BD5              * LocalMapPoint
3403 7BD5              *
3404 7BD5              ****************************************************************
3405 7BD5                       EXPORT LocalMapPoint 
3406 7BD5              LocalMapPoint PROC 
3407 7BD5
3408 7BD5              * The point to be mapped should be in @RgnPtrB with Y pointing
3409 7BD5              * at any offset.
3410 7BD5
3411 7BD5 B7 64                 lda   [RgnPtrB],y
3412 7BD7 85 F0                 sta   MapV
3413 7BD9 C8 C8                 IncYWd 
3414 7BDB B7 64                 lda   [RgnPtrB],y
3415 7BDD 85 F2                 sta   MapH
3416 7BDF 5A                    phy   
3417 7BE0 20 1A 7B              jsr   MapAndScale
3418 7BE3 7A                    ply   
3419 7BE4 A5 F2                 lda   MapH
3420 7BE6 97 64                 sta   [RgnPtrB],y
3421 7BE8 88 88                 DecYWd 
3422 7BEA A5 F0                 lda   MapV
3423 7BEC 97 64                 sta   [RgnPtrB],y
3424 7BEE 60                    rts   
3425 7BEF
3426 7BEF                       ENDP 
3427 7BEF
3428 7BEF              ****************************************************************
3429 7BEF              *
3430 7BEF              * MapRect
3431 7BEF              *
3432 7BEF              ****************************************************************
3433 7BEF                       EXPORT MapRect 
3434 7BEF              MapRect  PROC 
3435 7BEF              *              using E0Vectors
3436 7BEF
3437 7BEF              OrigDirect equ   1
3438 7BEF              RTL1     equ   OrigDirect+2
3439 7BEF              RTL2     equ   RTL1+3
3440 7BEF              ToRectPtr equ   RTL2+3
3441 7BEF              FromRectPtr equ   ToRectPtr+4
3442 7BEF              DstRect  equ   FromRectPtr+4
3443 7BEF
3444 7BEF 20 AA 0F              jsr   QDStart
3445 7BF2
3446 7BF2 20 AA 7A              jsr   RetrieveRects
3447 7BF5 22 C8 1F E0           jsl   SetScaleAndMap           ; set up the mapping values
3448 7BF9
3449 7BF9 A3 11                 lda   DstRect,s
3450 7BFB 85 64                 sta   RgnPtrB
3451 7BFD A3 13                 lda   DstRect+2,s
3452 7BFF 85 66                 sta   RgnPtrB+2
3453 7C01
3454 7C01 A0 00 00              ldy   #0
3455 7C04 20 D5 7B              jsr   LocalMapPoint
3456 7C07 A0 04 00              ldy   #4
3457 7C0A 20 D5 7B              jsr   LocalMapPoint
3458 7C0D
3459 7C0D 4C 71 FC              jmp   BusyEC12
3460 7C10
3461 7C10                       ENDP 
3462 7C10
3463 7C10              ****************************************************************
3464 7C10              *
3465 7C10              * MapPt
3466 7C10              *
3467 7C10              ****************************************************************
3468 7C10                       EXPORT MapPt 
3469 7C10              MapPt    PROC 
3470 7C10              *              using E0Vectors
3471 7C10
3472 7C10              OrigDirect equ   1
3473 7C10              RTL1     equ   OrigDirect+2
3474 7C10              RTL2     equ   RTL1+3
3475 7C10              ToRectPtr equ   RTL2+3
3476 7C10              FromRectPtr equ   ToRectPtr+4
3477 7C10              Point    equ   FromRectPtr+4
3478 7C10
3479 7C10 20 AA 0F              jsr   QDStart
3480 7C13
3481 7C13 20 AA 7A              jsr   RetrieveRects
3482 7C16 22 C8 1F E0           jsl   SetScaleAndMap           ; set up the mapping values
3483 7C1A
3484 7C1A A3 11                 lda   Point,s
3485 7C1C 85 64                 sta   RgnPtrB
3486 7C1E A3 13                 lda   Point+2,s
3487 7C20 85 66                 sta   RgnPtrB+2
3488 7C22 A0 00 00              ldy   #0
3489 7C25 20 D5 7B              jsr   LocalMapPoint
3490 7C28 4C 71 FC              jmp   BusyEC12
3491 7C2B
3492 7C2B                       ENDP 
3493 7C2B
3494 7C2B                       END   
